/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.slf4j.Logger;

public class EntityFishingHook
extends IProjectile {
    private static final Logger b = LogUtils.getLogger();
    private final RandomSource c = RandomSource.a();
    private boolean d;
    public int e;
    private static final int f = 10;
    public static final DataWatcherObject<Integer> g = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> h = DataWatcher.a(EntityFishingHook.class, DataWatcherRegistry.k);
    private int i;
    private int j;
    public int k;
    public int l;
    public float m;
    private boolean n = true;
    @Nullable
    public Entity o;
    public HookState p = HookState.a;
    private final int q;
    private final int r;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    private EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world, int luckBonus, int waitTimeReductionTicks) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.au = true;
        this.q = Math.max(0, luckBonus);
        this.r = Math.max(0, waitTimeReductionTicks);
        this.minWaitTime = world.paperConfig().fishingTimeRange.minimum;
        this.maxWaitTime = world.paperConfig().fishingTimeRange.maximum;
    }

    public EntityFishingHook(EntityTypes<? extends EntityFishingHook> type, World world) {
        this(type, world, 0, 0);
    }

    public EntityFishingHook(EntityHuman thrower, World world, int luckBonus, int waitTimeReductionTicks) {
        this(EntityTypes.bz, world, luckBonus, waitTimeReductionTicks);
        this.c(thrower);
        float f2 = thrower.dG();
        float f1 = thrower.dE();
        float f22 = MathHelper.b(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f3 = MathHelper.a(-f1 * ((float)Math.PI / 180) - (float)Math.PI);
        float f4 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float f5 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        double d0 = thrower.dt() - (double)f3 * 0.3;
        double d1 = thrower.dx();
        double d2 = thrower.dz() - (double)f22 * 0.3;
        this.b(d0, d1, d2, f1, f2);
        Vec3D vec3d = new Vec3D(-f3, MathHelper.a(-(f5 / f4), -5.0f, 5.0f), -f22);
        double d3 = vec3d.f();
        vec3d = vec3d.d(0.6 / d3 + this.ah.a(0.5, 0.0103365), 0.6 / d3 + this.ah.a(0.5, 0.0103365), 0.6 / d3 + this.ah.a(0.5, 0.0103365));
        this.i(vec3d);
        this.t((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
        this.u((float)(MathHelper.d(vec3d.d, vec3d.h()) * 57.2957763671875));
        this.O = this.dE();
        this.P = this.dG();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(g, 0);
        builder.a(h, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (g.equals(data)) {
            int i2 = this.ar().a(g);
            Entity entity = this.o = i2 > 0 ? this.dO().a(i2 - 1) : null;
        }
        if (h.equals(data)) {
            this.d = this.ar().a(h);
            if (this.d) {
                this.n(this.dr().c, -0.4f * MathHelper.a(this.c, 0.6f, 1.0f), this.dr().e);
            }
        }
        super.a(data);
    }

    @Override
    public boolean a(double distance) {
        double d1 = 64.0;
        return distance < 4096.0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
    }

    @Override
    public void l() {
        this.c.b(this.cz().getLeastSignificantBits() ^ this.dO().Z());
        super.l();
        EntityHuman entityhuman = this.t();
        if (entityhuman == null) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.dO().B || !this.a(entityhuman)) {
            boolean flag;
            if (this.aF()) {
                ++this.i;
                if (this.i >= 1200) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            } else {
                this.i = 0;
            }
            float f2 = 0.0f;
            BlockPosition blockposition = this.do();
            Fluid fluid = this.dO().b_(blockposition);
            if (fluid.a(TagsFluid.a)) {
                f2 = fluid.a((IBlockAccess)this.dO(), blockposition);
            }
            boolean bl = flag = f2 > 0.0f;
            if (this.p == HookState.a) {
                if (this.o != null) {
                    this.i(Vec3D.b);
                    this.p = HookState.b;
                    return;
                }
                if (flag) {
                    this.i(this.dr().d(0.3, 0.2, 0.3));
                    this.p = HookState.c;
                    return;
                }
                this.w();
            } else {
                if (this.p == HookState.b) {
                    if (this.o != null) {
                        if (!this.o.dJ() && this.o.dO().af() == this.dO().af()) {
                            this.a_(this.o.dt(), this.o.e(0.8), this.o.dz());
                        } else {
                            this.A(null);
                            this.p = HookState.a;
                        }
                    }
                    return;
                }
                if (this.p == HookState.c) {
                    Vec3D vec3d = this.dr();
                    double d0 = this.dv() + vec3d.d - (double)blockposition.v() - (double)f2;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.n(vec3d.c * 0.9, vec3d.d - d0 * (double)this.ah.i() * 0.2, vec3d.e * 0.9);
                    if (this.j <= 0 && this.l <= 0) {
                        this.n = true;
                    } else {
                        boolean bl2 = this.n = this.n && this.e < 10 && this.b(blockposition);
                    }
                    if (flag) {
                        this.e = Math.max(0, this.e - 1);
                        if (this.d) {
                            this.i(this.dr().b(0.0, -0.1 * (double)this.c.i() * (double)this.c.i(), 0.0));
                        }
                        if (!this.dO().B) {
                            this.a(blockposition);
                        }
                    } else {
                        this.e = Math.min(10, this.e + 1);
                    }
                }
            }
            if (!fluid.a(TagsFluid.a)) {
                this.i(this.dr().b(0.0, -0.03, 0.0));
            }
            this.a(EnumMoveType.a, this.dr());
            this.I();
            if (this.p == HookState.a && (this.aF() || this.Q)) {
                this.i(Vec3D.b);
            }
            double d1 = 0.92;
            this.i(this.dr().a(0.92));
            this.av();
        }
    }

    private boolean a(EntityHuman player) {
        ItemStack itemstack = player.eT();
        ItemStack itemstack1 = player.eU();
        boolean flag = itemstack.a(Items.qV);
        boolean flag1 = itemstack1.a(Items.qV);
        if (!player.dJ() && player.bE() && (flag || flag1) && this.g(player) <= 1024.0) {
            return false;
        }
        this.discard(EntityRemoveEvent.Cause.DESPAWN);
        return true;
    }

    private void w() {
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        this.preHitTargetOrDeflectSelf(movingobjectposition);
    }

    @Override
    public boolean b(Entity entity) {
        return super.b(entity) || entity.bE() && entity instanceof EntityItem;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        if (!this.dO().B) {
            this.A(entityHitResult.a());
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        this.i(this.dr().d().a(blockHitResult.a(this)));
    }

    public void A(@Nullable Entity entity) {
        this.o = entity;
        this.ar().a(g, entity == null ? 0 : entity.an() + 1);
    }

    private void a(BlockPosition pos) {
        WorldServer worldserver = (WorldServer)this.dO();
        int i2 = 1;
        BlockPosition blockposition1 = pos.d();
        if (this.rainInfluenced && this.ah.i() < 0.25f && this.dO().r(blockposition1)) {
            ++i2;
        }
        if (this.skyInfluenced && this.ah.i() < 0.5f && !this.dO().h(blockposition1)) {
            --i2;
        }
        if (this.j > 0) {
            --this.j;
            if (this.j <= 0) {
                this.k = 0;
                this.l = 0;
                this.ar().a(h, false);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.t().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.FAILED_ATTEMPT);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
            }
        } else if (this.l > 0) {
            this.l -= i2;
            if (this.l > 0) {
                double d2;
                double d1;
                this.m += (float)this.ah.a(0.0, 9.188);
                float f2 = this.m * ((float)Math.PI / 180);
                float f1 = MathHelper.a(f2);
                float f22 = MathHelper.b(f2);
                double d0 = this.dt() + (double)(f1 * (float)this.l * 0.1f);
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dv()) + 1.0f)) - 1.0, d2 = this.dz() + (double)(f22 * (float)this.l * 0.1f)));
                if (iblockdata.a(Blocks.G)) {
                    if (this.ah.i() < 0.15f) {
                        worldserver.a(Particles.d, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f22, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f22 * 0.04f;
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    worldserver.a(Particles.E, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((Player)this.t().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.BITE);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return;
                }
                this.a(SoundEffects.iX, 0.25f, 1.0f + (this.ah.i() - this.ah.i()) * 0.4f);
                double d3 = this.dv() + 0.5;
                worldserver.a(Particles.d, this.dt(), d3, this.dz(), (int)(1.0f + this.dj() * 20.0f), (double)this.dj(), 0.0, (double)this.dj(), 0.2f);
                worldserver.a(Particles.E, this.dt(), d3, this.dz(), (int)(1.0f + this.dj() * 20.0f), (double)this.dj(), 0.0, (double)this.dj(), 0.2f);
                this.j = MathHelper.a(this.ah, 20, 40);
                this.ar().a(h, true);
            }
        } else if (this.k > 0) {
            this.k -= i2;
            float f3 = 0.15f;
            if (this.k < 20) {
                f3 += (float)(20 - this.k) * 0.05f;
            } else if (this.k < 40) {
                f3 += (float)(40 - this.k) * 0.02f;
            } else if (this.k < 60) {
                f3 += (float)(60 - this.k) * 0.01f;
            }
            if (this.ah.i() < f3) {
                double d2;
                double d1;
                float f1 = MathHelper.a(this.ah, 0.0f, 360.0f) * ((float)Math.PI / 180);
                float f2 = MathHelper.a(this.ah, 25.0f, 60.0f);
                double d0 = this.dt() + (double)(MathHelper.a(f1) * f2) * 0.1;
                IBlockData iblockdata = worldserver.a_(BlockPosition.a(d0, (d1 = (double)((float)MathHelper.a(this.dv()) + 1.0f)) - 1.0, d2 = this.dz() + (double)(MathHelper.b(f1) * f2) * 0.1));
                if (iblockdata.a(Blocks.G)) {
                    worldserver.a(Particles.am, d0, d1, d2, 2 + this.ah.a(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.k <= 0) {
                PlayerFishEvent playerFishEvent;
                this.m = MathHelper.a(this.ah, this.minLureAngle, this.maxLureAngle);
                this.l = MathHelper.a(this.ah, this.minLureTime, this.maxLureTime);
                if (this.t() != null && !(playerFishEvent = new PlayerFishEvent((Player)this.t().getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), PlayerFishEvent.State.LURED)).callEvent()) {
                    this.l = 0;
                    return;
                }
            }
        } else {
            this.resetTimeUntilLured();
        }
    }

    public void resetTimeUntilLured() {
        this.k = MathHelper.a(this.ah, this.minWaitTime, this.maxWaitTime);
        this.k -= this.applyLure ? (this.r >= this.maxWaitTime ? this.k - 1 : this.r) : 0;
    }

    public boolean b(BlockPosition pos) {
        WaterPosition entityfishinghook_waterposition = WaterPosition.c;
        for (int i2 = -1; i2 <= 2; ++i2) {
            WaterPosition entityfishinghook_waterposition1 = this.a(pos.b(-2, i2, -2), pos.b(2, i2, 2));
            switch (entityfishinghook_waterposition1.ordinal()) {
                case 0: {
                    if (entityfishinghook_waterposition != WaterPosition.c) break;
                    return false;
                }
                case 1: {
                    if (entityfishinghook_waterposition != WaterPosition.a) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            entityfishinghook_waterposition = entityfishinghook_waterposition1;
        }
        return true;
    }

    private WaterPosition a(BlockPosition start, BlockPosition end) {
        return BlockPosition.d(start, end).map(this::c).reduce((entityfishinghook_waterposition, entityfishinghook_waterposition1) -> entityfishinghook_waterposition == entityfishinghook_waterposition1 ? entityfishinghook_waterposition : WaterPosition.c).orElse(WaterPosition.c);
    }

    private WaterPosition c(BlockPosition pos) {
        IBlockData iblockdata = this.dO().a_(pos);
        if (!iblockdata.i() && !iblockdata.a(Blocks.fm)) {
            Fluid fluid = iblockdata.u();
            return fluid.a(TagsFluid.a) && fluid.b() && iblockdata.k(this.dO(), pos).c() ? WaterPosition.b : WaterPosition.c;
        }
        return WaterPosition.a;
    }

    public boolean p() {
        return this.n;
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    @Deprecated
    @DoNotUse
    public int a(ItemStack usedItem) {
        return this.retrieve(EnumHand.a, usedItem);
    }

    public int retrieve(EnumHand hand, ItemStack usedItem) {
        EntityHuman entityhuman = this.t();
        if (!this.dO().B && entityhuman != null && !this.a(entityhuman)) {
            PlayerFishEvent playerFishEvent;
            int i2 = 0;
            if (this.o != null) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)this.o.getBukkitEntity(), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_ENTITY);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                if (this.o != null) {
                    this.d(this.o);
                    CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, Collections.emptyList());
                    this.dO().a((Entity)this, (byte)31);
                    i2 = this.o instanceof EntityItem ? 3 : 5;
                }
            } else if (this.j > 0) {
                LootParams lootparams = new LootParams.a((WorldServer)this.dO()).a(LootContextParameters.f, this.dm()).a(LootContextParameters.i, usedItem).a(LootContextParameters.a, this).a((float)this.q + entityhuman.gu()).a(LootContextParameterSets.f);
                LootTable loottable = this.dO().o().be().b(LootTables.aC);
                ObjectArrayList<ItemStack> list = loottable.a(lootparams);
                CriterionTriggers.E.a((EntityPlayer)entityhuman, usedItem, this, (Collection<ItemStack>)list);
                for (ItemStack itemstack1 : list) {
                    Entity entityitem = null;
                    if (!itemstack1.e()) {
                        entityitem = new EntityItem(this.dO(), this.dt(), this.dv(), this.dz(), itemstack1);
                    }
                    PlayerFishEvent playerFishEvent2 = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Entity)(entityitem != null ? entityitem.getBukkitEntity() : null), (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.CAUGHT_FISH);
                    playerFishEvent2.setExpToDrop(this.ah.a(6) + 1);
                    this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent2);
                    if (playerFishEvent2.isCancelled()) {
                        return 0;
                    }
                    double d0 = entityhuman.dt() - this.dt();
                    double d1 = entityhuman.dv() - this.dv();
                    double d2 = entityhuman.dz() - this.dz();
                    double d3 = 0.1;
                    if (entityitem != null) {
                        entityitem.n(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                        this.dO().b(entityitem);
                    }
                    if (playerFishEvent2.getExpToDrop() > 0) {
                        entityhuman.dO().b(new EntityExperienceOrb(entityhuman.dO(), entityhuman.dt(), entityhuman.dv() + 0.5, entityhuman.dz() + 0.5, playerFishEvent2.getExpToDrop(), ExperienceOrb.SpawnReason.FISHING, this.t(), this));
                    }
                    if (!itemstack1.a(TagsItem.aP)) continue;
                    entityhuman.a(StatisticList.R, 1);
                }
                i2 = 1;
            }
            if (this.aF()) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.IN_GROUND);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
                i2 = 2;
            }
            if (i2 == 0) {
                playerFishEvent = new PlayerFishEvent((Player)entityhuman.getBukkitEntity(), null, (FishHook)this.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.REEL_IN);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    return 0;
                }
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return i2;
        }
        return 0;
    }

    @Override
    public void b(byte status) {
        if (status == 31 && this.dO().B && this.o instanceof EntityHuman && ((EntityHuman)this.o).g()) {
            this.d(this.o);
        }
        super.b(status);
    }

    public void d(Entity entity) {
        Entity entity1 = this.s();
        if (entity1 != null) {
            Vec3D vec3d = new Vec3D(entity1.dt() - this.dt(), entity1.dv() - this.dv(), entity1.dz() - this.dz()).a(0.1);
            entity.i(entity.dr().e(vec3d));
        }
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.a((EntityFishingHook)null);
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void as() {
        this.a((EntityFishingHook)null);
    }

    @Override
    public void c(@Nullable Entity entity) {
        super.c(entity);
        this.a(this);
    }

    private void a(@Nullable EntityFishingHook fishingBobber) {
        EntityHuman entityhuman = this.t();
        if (entityhuman != null) {
            entityhuman.cv = fishingBobber;
        }
    }

    @Nullable
    public EntityHuman t() {
        Entity entity = this.s();
        return entity instanceof EntityHuman ? (EntityHuman)entity : null;
    }

    @Nullable
    public Entity v() {
        return this.o;
    }

    @Override
    public boolean o(boolean allowVehicles) {
        return false;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        Entity entity = this.s();
        return new PacketPlayOutSpawnEntity((Entity)this, entityTrackerEntry, entity == null ? this.an() : entity.an());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (this.t() == null) {
            int i2 = packet.p();
            b.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.dO().a(i2), (Object)i2);
            this.ap();
        }
    }

    public static enum HookState {
        a,
        b,
        c;

    }

    private static enum WaterPosition {
        a,
        b,
        c;

    }
}

