/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double b = 0.15;
    @Nullable
    private Entity c;
    @Nullable
    public EnumDirection d;
    public int e;
    public double f;
    public double g;
    public double h;
    @Nullable
    private UUID i;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.ag = true;
    }

    public EntityShulkerBullet(World world, EntityLiving owner, Entity target, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.aL, world);
        this.c(owner);
        Vec3D vec3d = owner.cK().f();
        this.b(vec3d.c, vec3d.d, vec3d.e, this.dE(), this.dG());
        this.c = target;
        this.d = EnumDirection.b;
        this.a(axis);
        this.projectileSource = (LivingEntity)owner.getBukkitEntity();
    }

    public Entity getTarget() {
        return this.c;
    }

    public void setTarget(Entity e2) {
        this.c = e2;
        this.d = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a);
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.f;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.c != null) {
            nbt.a("Target", this.c.cz());
        }
        if (this.d != null) {
            nbt.a("Dir", this.d.d());
        }
        nbt.a("Steps", this.e);
        nbt.a("TXD", this.f);
        nbt.a("TYD", this.g);
        nbt.a("TZD", this.h);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Steps");
        this.f = nbt.k("TXD");
        this.g = nbt.k("TYD");
        this.h = nbt.k("TZD");
        if (nbt.b("Dir", 99)) {
            this.d = EnumDirection.a(nbt.h("Dir"));
        }
        if (nbt.b("Target")) {
            this.i = nbt.a("Target");
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Nullable
    private EnumDirection p() {
        return this.d;
    }

    private void a(@Nullable EnumDirection direction) {
        this.d = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (this.c == null) {
            blockposition = this.do().e();
        } else {
            d0 = (double)this.c.dk() * 0.5;
            blockposition = BlockPosition.a(this.c.dt(), this.c.dv() + d0, this.c.dz());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.dm(), 2.0)) {
            BlockPosition blockposition1 = this.do();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.dO().u(blockposition1.i())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.dO().u(blockposition1.h())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.dO().u(blockposition1.d())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.dO().u(blockposition1.e())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.dO().u(blockposition1.g())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.dO().u(blockposition1.f())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.b(this.ah);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.dO().u(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.b(this.ah);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.ah.a(list.size()));
            }
            d1 = this.dt() + (double)enumdirection.j();
            d2 = this.dv() + (double)enumdirection.k();
            d3 = this.dz() + (double)enumdirection.l();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dt();
        double d5 = d2 - this.dv();
        double d6 = d3 - this.dz();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.f = 0.0;
            this.g = 0.0;
            this.h = 0.0;
        } else {
            this.f = d4 / d7 * 0.15;
            this.g = d5 / d7 * 0.15;
            this.h = d6 / d7 * 0.15;
        }
        this.av = true;
        this.e = 10 + this.ah.a(5) * 10;
    }

    @Override
    public void dA() {
        if (this.dO().al() == EnumDifficulty.a) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        Vec3D vec3d;
        super.l();
        if (!this.dO().B) {
            if (this.c == null && this.i != null) {
                this.c = ((WorldServer)this.dO()).a(this.i);
                if (this.c == null) {
                    this.i = null;
                }
            }
            if (!(this.c == null || !this.c.bE() || this.c instanceof EntityHuman && this.c.R_())) {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.g = MathHelper.a(this.g * 1.025, -1.0, 1.0);
                this.h = MathHelper.a(this.h * 1.025, -1.0, 1.0);
                vec3d = this.dr();
                this.i(vec3d.b((this.f - vec3d.c) * 0.2, (this.g - vec3d.d) * 0.2, (this.h - vec3d.e) * 0.2));
            } else {
                this.bb();
            }
            MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
            if (movingobjectposition.c() != MovingObjectPosition.EnumMovingObjectType.a) {
                this.preHitTargetOrDeflectSelf(movingobjectposition);
            }
        }
        this.aT();
        vec3d = this.dr();
        this.a_(this.dt() + vec3d.c, this.dv() + vec3d.d, this.dz() + vec3d.e);
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.dO().B) {
            this.dO().a(Particles.t, this.dt() - vec3d.c, this.dv() - vec3d.d + 0.15, this.dz() - vec3d.e, 0.0, 0.0, 0.0);
        } else if (this.c != null && !this.c.dJ()) {
            if (this.e > 0) {
                --this.e;
                if (this.e == 0) {
                    this.a(this.d == null ? null : this.d.o());
                }
            }
            if (this.d != null) {
                BlockPosition blockposition = this.do();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.d.o();
                if (this.dO().a(blockposition.a(this.d), this)) {
                    this.a(enumdirection_enumaxis);
                } else {
                    BlockPosition blockposition1 = this.c.do();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis);
                    }
                }
            }
        }
    }

    @Override
    public boolean b(Entity entity) {
        return super.b(entity) && !entity.ag;
    }

    @Override
    public boolean bR() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float bu() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        Entity entity1 = this.s();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        DamageSource damagesource = this.dP().a((Entity)this, entityliving);
        boolean flag = entity.a(damagesource, 4.0f);
        if (flag) {
            World world = this.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                entityliving1.addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        ((WorldServer)this.dO()).a(Particles.w, this.dt(), this.dv(), this.dz(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.wO, 1.0f, 1.0f);
    }

    private void t() {
        this.destroy(null);
    }

    private void destroy(EntityRemoveEvent.Cause cause) {
        this.discard(cause);
        this.dO().a(GameEvent.o, this.dm(), GameEvent.a.a(this));
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        this.destroy(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public boolean bA() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
            return false;
        }
        if (!this.dO().B) {
            this.a(SoundEffects.wP, 1.0f, 1.0f);
            ((WorldServer)this.dO()).a(Particles.f, this.dt(), this.dv(), this.dz(), 15, 0.2, 0.2, 0.2, 0.0);
            this.destroy(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double d0 = packet.j();
        double d1 = packet.k();
        double d2 = packet.l();
        this.n(d0, d1, d2);
    }
}

