/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityFireballFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntitySmallFireball
extends EntityFireballFireball {
    public EntitySmallFireball(EntityTypes<? extends EntitySmallFireball> type, World world) {
        super((EntityTypes<? extends EntityFireballFireball>)type, world);
    }

    public EntitySmallFireball(World world, EntityLiving owner, Vec3D velocity) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.aQ, owner, velocity, world);
        if (this.s() != null && this.s() instanceof EntityInsentient) {
            this.isIncendiary = this.dO().ab().b(GameRules.c);
        }
    }

    public EntitySmallFireball(World world, double x2, double y2, double z2, Vec3D velocity) {
        super((EntityTypes<? extends EntityFireballFireball>)EntityTypes.aQ, x2, y2, z2, velocity, world);
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        World world = this.dO();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = entityHitResult.a();
            Entity entity1 = this.s();
            int i2 = entity.aC();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)((Projectile)this.getBukkitEntity()), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            entity.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                entity.igniteForSeconds(event.getDuration(), false);
            }
            if (!entity.a(damagesource = this.dP().a(this, entity1), 5.0f)) {
                entity.h(i2);
            } else {
                EnchantmentManager.a(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        if (!this.dO().B) {
            Entity entity = this.s();
            if (this.isIncendiary) {
                BlockPosition blockposition = blockHitResult.a().a(blockHitResult.b());
                if (this.dO().u(blockposition) && !CraftEventFactory.callBlockIgniteEvent(this.dO(), blockposition, this).isCancelled()) {
                    this.dO().b(blockposition, BlockFireAbstract.a(this.dO(), blockposition));
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.dO().B) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        return false;
    }
}

