/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWitherSkull
extends EntityFireball {
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(EntityWitherSkull.class, DataWatcherRegistry.k);

    public EntityWitherSkull(EntityTypes<? extends EntityWitherSkull> type, World world) {
        super((EntityTypes<? extends EntityFireball>)type, world);
    }

    public EntityWitherSkull(World world, EntityLiving owner, Vec3D velocity) {
        super(EntityTypes.br, owner, velocity, world);
    }

    @Override
    protected float w() {
        return this.y() ? 0.73f : super.w();
    }

    @Override
    public boolean bR() {
        return false;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return this.y() && EntityWither.c(blockState) ? Math.min(0.8f, max) : max;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        World world = this.dO();
        if (world instanceof WorldServer) {
            boolean flag;
            EntityLiving entityliving;
            WorldServer worldserver = (WorldServer)world;
            Entity entity = entityHitResult.a();
            Entity entity1 = this.s();
            if (entity1 instanceof EntityLiving) {
                entityliving = (EntityLiving)entity1;
                DamageSource damagesource = this.dP().a(this, (Entity)entityliving);
                flag = entity.a(damagesource, 8.0f);
                if (flag) {
                    if (entity.bE()) {
                        EnchantmentManager.a(worldserver, entity, damagesource);
                    } else {
                        entityliving.heal(5.0f, EntityRegainHealthEvent.RegainReason.WITHER);
                    }
                }
            } else {
                flag = entity.a(this.dP().p().customEventDamager(this), 5.0f);
            }
            if (flag && entity instanceof EntityLiving) {
                entityliving = (EntityLiving)entity;
                int b0 = 0;
                if (this.dO().al() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.dO().al() == EnumDifficulty.d) {
                    b0 = 40;
                }
                if (b0 > 0) {
                    entityliving.addEffect(new MobEffect(MobEffects.t, 20 * b0, 1), this.H(), EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.dO().B) {
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f, false);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.dO().a((Entity)this, this.dt(), this.dv(), this.dz(), event.getRadius(), event.getFire(), World.a.c);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        return false;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(e, false);
    }

    public boolean y() {
        return this.ao.a(e);
    }

    public void a(boolean charged) {
        this.ao.a(e, charged);
    }

    @Override
    protected boolean t() {
        return false;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("dangerous", this.y());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("dangerous"));
    }
}

