/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public final class ProjectileHelper {
    private static final float a = 0.3f;

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate) {
        Vec3D vec3 = entity.dr();
        World level = entity.dO();
        Vec3D vec32 = entity.dm();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.3f, RayTrace.BlockCollisionOption.a);
    }

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate, RayTrace.BlockCollisionOption raycastShapeType) {
        Vec3D vec3 = entity.dr();
        World level = entity.dO();
        Vec3D vec32 = entity.dm();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.3f, raycastShapeType);
    }

    public static MovingObjectPosition a(Entity entity, Predicate<Entity> predicate, double range) {
        Vec3D vec3 = entity.g(0.0f).a(range);
        World level = entity.dO();
        Vec3D vec32 = entity.by();
        return ProjectileHelper.a(vec32, entity, predicate, vec3, level, 0.0f, RayTrace.BlockCollisionOption.a);
    }

    private static MovingObjectPosition a(Vec3D pos, Entity entity, Predicate<Entity> predicate, Vec3D velocity, World world, float margin, RayTrace.BlockCollisionOption raycastShapeType) {
        MovingObjectPositionEntity hitResult2;
        Vec3D vec3 = pos.e(velocity);
        MovingObjectPosition hitResult = world.a(new RayTrace(pos, vec3, raycastShapeType, RayTrace.FluidCollisionOption.a, entity));
        if (((MovingObjectPosition)hitResult).c() != MovingObjectPosition.EnumMovingObjectType.a) {
            vec3 = hitResult.e();
        }
        if ((hitResult2 = ProjectileHelper.a(world, entity, pos, vec3, entity.cK().b(velocity).g(1.0), predicate, margin)) != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    @Nullable
    public static MovingObjectPositionEntity a(Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate, double maxDistance) {
        World level = entity.dO();
        double d2 = maxDistance;
        Entity entity2 = null;
        Vec3D vec3 = null;
        for (Entity entity3 : level.a(entity, box, predicate)) {
            Vec3D vec32;
            double e2;
            AxisAlignedBB aABB = entity3.cK().g(entity3.bL());
            Optional<Vec3D> optional = aABB.b(min, max);
            if (aABB.d(min)) {
                if (!(d2 >= 0.0)) continue;
                entity2 = entity3;
                vec3 = optional.orElse(min);
                d2 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((e2 = min.g(vec32 = optional.get())) < d2) && d2 != 0.0) continue;
            if (entity3.cZ() == entity.cZ()) {
                if (d2 != 0.0) continue;
                entity2 = entity3;
                vec3 = vec32;
                continue;
            }
            entity2 = entity3;
            vec3 = vec32;
            d2 = e2;
        }
        if (entity2 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(entity2, vec3);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World world, Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate) {
        return ProjectileHelper.a(world, entity, min, max, box, predicate, 0.3f);
    }

    @Nullable
    public static MovingObjectPositionEntity a(World world, Entity entity, Vec3D min, Vec3D max, AxisAlignedBB box, Predicate<Entity> predicate, float margin) {
        double d2 = Double.MAX_VALUE;
        Entity entity2 = null;
        for (Entity entity3 : world.a(entity, box, predicate)) {
            double e2;
            AxisAlignedBB aABB = entity3.cK().g(margin);
            Optional<Vec3D> optional = aABB.b(min, max);
            if (!optional.isPresent() || !((e2 = min.g(optional.get())) < d2)) continue;
            entity2 = entity3;
            d2 = e2;
        }
        if (entity2 == null) {
            return null;
        }
        return new MovingObjectPositionEntity(entity2);
    }

    public static void a(Entity entity, float delta) {
        Vec3D vec3 = entity.dr();
        if (vec3.g() == 0.0) {
            return;
        }
        double d2 = vec3.h();
        entity.t((float)(MathHelper.d(vec3.e, vec3.c) * 57.2957763671875) + 90.0f);
        entity.u((float)(MathHelper.d(d2, vec3.d) * 57.2957763671875) - 90.0f);
        while (entity.dG() - entity.P < -180.0f) {
            entity.P -= 360.0f;
        }
        while (entity.dG() - entity.P >= 180.0f) {
            entity.P += 360.0f;
        }
        while (entity.dE() - entity.O < -180.0f) {
            entity.O -= 360.0f;
        }
        while (entity.dE() - entity.O >= 180.0f) {
            entity.O += 360.0f;
        }
        entity.u(MathHelper.i(delta, entity.P, entity.dG()));
        entity.t(MathHelper.i(delta, entity.O, entity.dE()));
    }

    public static EnumHand a(EntityLiving entity, Item item) {
        return entity.eT().a(item) ? EnumHand.a : EnumHand.b;
    }

    public static EntityArrow a(EntityLiving entity, ItemStack stack, float damageModifier, @Nullable ItemStack bow) {
        ItemArrow arrowItem = (ItemArrow)(stack.g() instanceof ItemArrow ? stack.g() : Items.ow);
        EntityArrow abstractArrow = arrowItem.a(entity.dO(), stack, entity, bow);
        abstractArrow.a(damageModifier);
        return abstractArrow;
    }
}

