/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class AdventureModePredicate {
    private static final Codec<AdventureModePredicate> e = CriterionConditionBlock.a.flatComapMap(predicate -> new AdventureModePredicate(List.of(predicate), true), checker -> DataResult.error(() -> "Cannot encode"));
    private static final Codec<AdventureModePredicate> f = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(CriterionConditionBlock.a.listOf()).fieldOf("predicates").forGetter(checker -> checker.h), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AdventureModePredicate::a)).apply((Applicative)instance, AdventureModePredicate::new));
    public static final Codec<AdventureModePredicate> a = Codec.withAlternative(f, e);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> b = StreamCodec.a(CriterionConditionBlock.b.a(ByteBufCodecs.a()), adventureModePredicate -> adventureModePredicate.h, ByteBufCodecs.b, AdventureModePredicate::a, AdventureModePredicate::new);
    public static final IChatBaseComponent c = IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h);
    public static final IChatBaseComponent d = IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h);
    private static final IChatBaseComponent g = IChatBaseComponent.c("item.canUse.unknown").a(EnumChatFormat.h);
    public final List<CriterionConditionBlock> h;
    private final boolean i;
    private final List<IChatBaseComponent> j;
    @Nullable
    private ShapeDetectorBlock k;
    private boolean l;
    private boolean m;

    private AdventureModePredicate(List<CriterionConditionBlock> predicates, boolean showInTooltip, List<IChatBaseComponent> tooltipText) {
        this.h = predicates;
        this.i = showInTooltip;
        this.j = tooltipText;
    }

    public AdventureModePredicate(List<CriterionConditionBlock> predicates, boolean showInTooltip) {
        this.h = predicates;
        this.i = showInTooltip;
        this.j = AdventureModePredicate.a(predicates);
    }

    private static boolean a(ShapeDetectorBlock pos, @Nullable ShapeDetectorBlock cachedPos, boolean nbtAware) {
        if (cachedPos == null || pos.a() != cachedPos.a()) {
            return false;
        }
        if (!nbtAware) {
            return true;
        }
        if (pos.b() == null && cachedPos.b() == null) {
            return true;
        }
        if (pos.b() == null || cachedPos.b() == null) {
            return false;
        }
        IRegistryCustom registryAccess = pos.c().H_();
        return Objects.equals(pos.b().c(registryAccess), cachedPos.b().c(registryAccess));
    }

    public boolean a(ShapeDetectorBlock cachedPos) {
        if (AdventureModePredicate.a(cachedPos, this.k, this.m)) {
            return this.l;
        }
        this.k = cachedPos;
        this.m = false;
        for (CriterionConditionBlock blockPredicate : this.h) {
            if (!blockPredicate.a(cachedPos)) continue;
            this.m |= blockPredicate.a();
            this.l = true;
            return true;
        }
        this.l = false;
        return false;
    }

    public void a(Consumer<IChatBaseComponent> adder) {
        this.j.forEach(adder);
    }

    public AdventureModePredicate a(boolean showInTooltip) {
        return new AdventureModePredicate(this.h, showInTooltip, this.j);
    }

    private static List<IChatBaseComponent> a(List<CriterionConditionBlock> blockPredicates) {
        for (CriterionConditionBlock blockPredicate : blockPredicates) {
            if (!blockPredicate.b().isEmpty()) continue;
            return List.of(g);
        }
        return blockPredicates.stream().flatMap(predicate -> predicate.b().orElseThrow().a()).distinct().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).toList();
    }

    public boolean a() {
        return this.i;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AdventureModePredicate) {
            AdventureModePredicate adventureModePredicate = (AdventureModePredicate)object;
            return this.h.equals(adventureModePredicate.h) && this.i == adventureModePredicate.i;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.h.hashCode() * 31 + (this.i ? 1 : 0);
    }

    @Override
    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.h) + ", showInTooltip=" + this.i + "}";
    }
}

