/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private final TagKey<Instrument> a;

    public InstrumentItem(Item.Info settings, TagKey<Instrument> instrumentTag) {
        super(settings);
        this.a = instrumentTag;
    }

    @Override
    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        super.a(stack, context, tooltip, type);
        Optional optional = this.i(stack).flatMap(Holder::e);
        if (optional.isPresent()) {
            IChatMutableComponent mutableComponent = IChatBaseComponent.c(SystemUtils.a("instrument", ((ResourceKey)optional.get()).a()));
            tooltip.add(mutableComponent.a(EnumChatFormat.h));
        }
    }

    public static ItemStack a(Item item, Holder<Instrument> instrument) {
        ItemStack itemStack = new ItemStack(item);
        itemStack.b(DataComponents.P, instrument);
        return itemStack;
    }

    public static void a(ItemStack stack, TagKey<Instrument> instrumentTag, RandomSource random) {
        Optional<Holder<Instrument>> optional = BuiltInRegistries.ak.a(instrumentTag, random);
        optional.ifPresent(instrument -> stack.b(DataComponents.P, instrument));
    }

    @Override
    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        Optional<Holder<Instrument>> optional = this.i(itemStack);
        if (optional.isPresent()) {
            Instrument instrument = optional.get().a();
            user.c(hand);
            InstrumentItem.a(world, user, instrument);
            user.gt().a((Item)this, instrument.b());
            user.b(StatisticList.c.b(this));
            return InteractionResultWrapper.b(itemStack);
        }
        return InteractionResultWrapper.d(itemStack);
    }

    @Override
    @Override
    public int a(ItemStack stack, EntityLiving user) {
        Optional<Holder<Instrument>> optional = this.i(stack);
        return optional.map(instrument -> ((Instrument)instrument.a()).b()).orElse(0);
    }

    private Optional<Holder<Instrument>> i(ItemStack stack) {
        Holder<Instrument> holder = stack.a(DataComponents.P);
        if (holder != null) {
            return Optional.of(holder);
        }
        Iterator<Holder<Instrument>> iterator = BuiltInRegistries.ak.c(this.a).iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    @Override
    @Override
    public EnumAnimation b(ItemStack stack) {
        return EnumAnimation.i;
    }

    private static void a(World world, EntityHuman player, Instrument instrument) {
        SoundEffect soundEvent = instrument.a().a();
        float f2 = instrument.c() / 16.0f;
        world.a(player, player, soundEvent, SoundCategory.c, f2, 1.0f);
        world.a(GameEvent.B, player.dm(), GameEvent.a.a(player));
    }
}

