/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemCrossbow
extends ItemProjectileWeapon {
    private static final float k = 1.25f;
    public static final int a = 8;
    private boolean l = false;
    private boolean m = false;
    private static final float n = 0.2f;
    private static final float o = 0.5f;
    private static final float p = 3.15f;
    public static final float q = 1.6f;
    public static final float b = 1.6f;
    private static final a r = new a(Optional.of(SoundEffects.gq), Optional.of(SoundEffects.gp), Optional.of(SoundEffects.go));

    public ItemCrossbow(Item.Info settings) {
        super(settings);
    }

    @Override
    public Predicate<ItemStack> d() {
        return ItemProjectileWeapon.j;
    }

    @Override
    public Predicate<ItemStack> b() {
        return ItemProjectileWeapon.c;
    }

    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        ChargedProjectiles chargedProjectiles = itemStack.a(DataComponents.E);
        if (chargedProjectiles != null && !chargedProjectiles.b()) {
            this.a(world, user, hand, itemStack, ItemCrossbow.a(chargedProjectiles), 1.0f, null);
            return InteractionResultWrapper.b(itemStack);
        }
        if (!user.g(itemStack).e()) {
            this.l = false;
            this.m = false;
            user.c(hand);
            return InteractionResultWrapper.b(itemStack);
        }
        return InteractionResultWrapper.d(itemStack);
    }

    private static float a(ChargedProjectiles stack) {
        return stack.a(Items.uu) ? 1.6f : 3.15f;
    }

    @Override
    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
        int i2 = this.a(stack, user) - remainingUseTicks;
        float f2 = ItemCrossbow.a(i2, stack, user);
        if (f2 >= 1.0f && !ItemCrossbow.i(stack)) {
            EntityLoadCrossbowEvent event = new EntityLoadCrossbowEvent((LivingEntity)user.getBukkitLivingEntity(), stack.asBukkitMirror(), CraftEquipmentSlot.getHand(user.fs()));
            if (!(event.callEvent() && ItemCrossbow.tryLoadProjectiles(user, stack, event.shouldConsumeItem()) && event.shouldConsumeItem())) {
                if (user instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)user;
                    player.cd.b();
                }
                return;
            }
            a chargingSounds = this.k(stack);
            chargingSounds.c().ifPresent(sound -> world.a(null, user.dt(), user.dv(), user.dz(), (SoundEffect)sound.a(), user.de(), 1.0f, 1.0f / (world.E_().i() * 0.5f + 1.0f) + 0.2f));
        }
    }

    @DoNotUse
    private static boolean a(EntityLiving shooter, ItemStack crossbow) {
        return ItemCrossbow.tryLoadProjectiles(shooter, crossbow, true);
    }

    private static boolean tryLoadProjectiles(EntityLiving shooter, ItemStack crossbow, boolean consume) {
        List<ItemStack> list = ItemCrossbow.draw(crossbow, shooter.g(crossbow), shooter, consume);
        if (!list.isEmpty()) {
            crossbow.b(DataComponents.E, ChargedProjectiles.a(list));
            return true;
        }
        return false;
    }

    public static boolean i(ItemStack stack) {
        ChargedProjectiles chargedProjectiles = stack.a(DataComponents.E, ChargedProjectiles.a);
        return !chargedProjectiles.b();
    }

    @Override
    protected void a(EntityLiving shooter, IProjectile projectile, int index, float speed, float divergence, float yaw, @Nullable EntityLiving target) {
        Vector3f vector3f;
        if (target != null) {
            double d2 = target.dt() - shooter.dt();
            double e2 = target.dz() - shooter.dz();
            double f2 = Math.sqrt(d2 * d2 + e2 * e2);
            double g2 = target.e(0.3333333333333333) - projectile.dv() + f2 * (double)0.2f;
            vector3f = ItemCrossbow.a(shooter, new Vec3D(d2, g2, e2), yaw);
        } else {
            Vec3D vec3 = shooter.j(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vec3.c, vec3.d, vec3.e);
            Vec3D vec32 = shooter.g(1.0f);
            vector3f = vec32.j().rotate((Quaternionfc)quaternionf);
        }
        projectile.c(vector3f.x(), vector3f.y(), vector3f.z(), speed, divergence);
        float h2 = ItemCrossbow.a(shooter.dR(), index);
        shooter.dO().a(null, shooter.dt(), shooter.dv(), shooter.dz(), SoundEffects.gu, shooter.de(), 1.0f, h2);
    }

    private static Vector3f a(EntityLiving shooter, Vec3D direction, float yaw) {
        Vector3f vector3f = direction.j().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            Vec3D vec3 = shooter.j(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.j());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(yaw * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    @Override
    protected IProjectile a(World world, EntityLiving shooter, ItemStack weaponStack, ItemStack projectileStack, boolean critical) {
        if (projectileStack.a(Items.uu)) {
            EntityFireworks entity = new EntityFireworks(world, projectileStack, shooter, shooter.dt(), shooter.dx() - (double)0.15f, shooter.dz(), true);
            entity.spawningEntity = shooter.cz();
            return entity;
        }
        IProjectile projectile = super.a(world, shooter, weaponStack, projectileStack, critical);
        if (projectile instanceof EntityArrow) {
            EntityArrow abstractArrow = (EntityArrow)projectile;
            abstractArrow.b(SoundEffects.gn);
        }
        return projectile;
    }

    @Override
    protected int j(ItemStack projectile) {
        return projectile.a(Items.uu) ? 3 : 1;
    }

    public void a(World world, EntityLiving shooter, EnumHand hand, ItemStack stack, float speed, float divergence, @Nullable EntityLiving target) {
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ChargedProjectiles chargedProjectiles = stack.b(DataComponents.E, ChargedProjectiles.a);
            if (chargedProjectiles != null && !chargedProjectiles.b()) {
                this.a(serverLevel, shooter, hand, stack, chargedProjectiles.a(), speed, divergence, shooter instanceof EntityHuman, target);
                if (shooter instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)shooter;
                    CriterionTriggers.G.a(serverPlayer, stack);
                    serverPlayer.b(StatisticList.c.b(stack.g()));
                }
            }
        }
    }

    private static float a(RandomSource random, int index) {
        return index == 0 ? 1.0f : ItemCrossbow.a((index & 1) == 1, random);
    }

    private static float a(boolean flag, RandomSource random) {
        float f2 = flag ? 0.63f : 0.43f;
        return 1.0f / (random.i() * 0.5f + 1.8f) + f2;
    }

    @Override
    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
        if (!world.B) {
            a chargingSounds = this.k(stack);
            float f2 = (float)(stack.a(user) - remainingUseTicks) / (float)ItemCrossbow.b(stack, user);
            if (f2 < 0.2f) {
                this.l = false;
                this.m = false;
            }
            if (f2 >= 0.2f && !this.l) {
                this.l = true;
                chargingSounds.a().ifPresent(sound -> world.a(null, user.dt(), user.dv(), user.dz(), (SoundEffect)sound.a(), SoundCategory.h, 0.5f, 1.0f));
            }
            if (f2 >= 0.5f && !this.m) {
                this.m = true;
                chargingSounds.b().ifPresent(sound -> world.a(null, user.dt(), user.dv(), user.dz(), (SoundEffect)sound.a(), SoundCategory.h, 0.5f, 1.0f));
            }
        }
    }

    @Override
    public int a(ItemStack stack, EntityLiving user) {
        return ItemCrossbow.b(stack, user) + 3;
    }

    public static int b(ItemStack stack, EntityLiving user) {
        float f2 = EnchantmentManager.a(stack, user, 1.25f);
        return MathHelper.d(f2 * 20.0f);
    }

    @Override
    public EnumAnimation b(ItemStack stack) {
        return EnumAnimation.g;
    }

    a k(ItemStack stack) {
        return EnchantmentManager.b(stack, EnchantmentEffectComponents.B).orElse(r);
    }

    private static float a(int useTicks, ItemStack stack, EntityLiving user) {
        float f2 = (float)useTicks / (float)ItemCrossbow.b(stack, user);
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
        ChargedProjectiles chargedProjectiles = stack.a(DataComponents.E);
        if (chargedProjectiles != null && !chargedProjectiles.b()) {
            ItemStack itemStack = chargedProjectiles.a().get(0);
            tooltip.add(IChatBaseComponent.c("item.minecraft.crossbow.projectile").b(CommonComponents.v).b(itemStack.F()));
            if (type.a() && itemStack.a(Items.uu)) {
                ArrayList list = Lists.newArrayList();
                Items.uu.a(itemStack, context, list, type);
                if (!list.isEmpty()) {
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        list.set(i2, IChatBaseComponent.b("  ").b((IChatBaseComponent)list.get(i2)).a(EnumChatFormat.h));
                    }
                    tooltip.addAll(list);
                }
            }
        }
    }

    @Override
    public boolean l(ItemStack stack) {
        return stack.a(this);
    }

    @Override
    public int c() {
        return 8;
    }

    public static final class a
    extends Record {
        private final Optional<Holder<SoundEffect>> b;
        private final Optional<Holder<SoundEffect>> c;
        private final Optional<Holder<SoundEffect>> d;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)SoundEffect.b.optionalFieldOf("start").forGetter(a::a), (App)SoundEffect.b.optionalFieldOf("mid").forGetter(a::b), (App)SoundEffect.b.optionalFieldOf("end").forGetter(a::c)).apply((Applicative)instance, a::new));

        public a(Optional<Holder<SoundEffect>> start, Optional<Holder<SoundEffect>> mid, Optional<Holder<SoundEffect>> end) {
            this.b = start;
            this.c = mid;
            this.d = end;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "start;mid;end", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "start;mid;end", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "start;mid;end", "b", "c", "d"}, this, o2);
        }

        public Optional<Holder<SoundEffect>> a() {
            return this.b;
        }

        public Optional<Holder<SoundEffect>> b() {
            return this.c;
        }

        public Optional<Holder<SoundEffect>> c() {
            return this.d;
        }
    }
}

