/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public final class JukeboxPlayable
extends Record
implements TooltipProvider {
    private final EitherHolder<JukeboxSong> c;
    private final boolean d;
    public static final Codec<JukeboxPlayable> a = RecordCodecBuilder.create(instance -> instance.group((App)EitherHolder.a(Registries.L, JukeboxSong.c).fieldOf("song").forGetter(JukeboxPlayable::a), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(JukeboxPlayable::b)).apply((Applicative)instance, JukeboxPlayable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, JukeboxPlayable> b = StreamCodec.a(EitherHolder.a(Registries.L, JukeboxSong.d), JukeboxPlayable::a, ByteBufCodecs.b, JukeboxPlayable::b, JukeboxPlayable::new);

    public JukeboxPlayable(EitherHolder<JukeboxSong> eitherHolder, boolean bl) {
        this.c = eitherHolder;
        this.d = bl;
    }

    @Override
    @Override
    public void a(Item.b context, Consumer<IChatBaseComponent> tooltip, TooltipFlag type) {
        HolderLookup.a provider = context.a();
        if (this.d && provider != null) {
            this.c.a(provider).ifPresent(holder -> {
                IChatMutableComponent mutableComponent = ((JukeboxSong)holder.a()).c().f();
                ChatComponentUtils.a(mutableComponent, ChatModifier.a.a(EnumChatFormat.h));
                tooltip.accept(mutableComponent);
            });
        }
    }

    public JukeboxPlayable a(boolean showInTooltip) {
        return new JukeboxPlayable(this.c, showInTooltip);
    }

    public static ItemInteractionResult a(World world, BlockPosition pos, ItemStack stack, EntityHuman player) {
        JukeboxPlayable jukeboxPlayable = stack.a(DataComponents.R);
        if (jukeboxPlayable == null) {
            return ItemInteractionResult.d;
        }
        IBlockData blockState = world.a_(pos);
        if (!blockState.a(Blocks.dT) || blockState.c(BlockJukeBox.b).booleanValue()) {
            return ItemInteractionResult.d;
        }
        if (!world.B) {
            ItemStack itemStack = stack.b(1, (EntityLiving)player);
            TileEntity tileEntity = world.c_(pos);
            if (tileEntity instanceof TileEntityJukeBox) {
                TileEntityJukeBox jukeboxBlockEntity = (TileEntityJukeBox)tileEntity;
                jukeboxBlockEntity.b(itemStack);
                world.a(GameEvent.c, pos, GameEvent.a.a(player, blockState));
            }
            player.a(StatisticList.al);
        }
        return ItemInteractionResult.a(world.B);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{JukeboxPlayable.class, "song;showInTooltip", "c", "d"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{JukeboxPlayable.class, "song;showInTooltip", "c", "d"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{JukeboxPlayable.class, "song;showInTooltip", "c", "d"}, this, object);
    }

    public EitherHolder<JukeboxSong> a() {
        return this.c;
    }

    public boolean b() {
        return this.d;
    }
}

