/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class BundleContents
implements TooltipComponent {
    public static final BundleContents a = new BundleContents(List.of());
    public static final Codec<BundleContents> b = ItemStack.b.listOf().xmap(BundleContents::new, component -> component.f);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> c = ItemStack.i.a(ByteBufCodecs.a()).a(BundleContents::new, component -> component.f);
    private static final Fraction d = Fraction.getFraction((int)1, (int)16);
    private static final int e = -1;
    final List<ItemStack> f;
    final Fraction g;

    BundleContents(List<ItemStack> stacks, Fraction occupancy) {
        this.f = stacks;
        this.g = occupancy;
    }

    public BundleContents(List<ItemStack> stacks) {
        this(stacks, BundleContents.a(stacks));
    }

    private static Fraction a(List<ItemStack> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemStack : stacks) {
            fraction = fraction.add(BundleContents.a(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.H(), (int)1)));
        }
        return fraction;
    }

    static Fraction a(ItemStack stack) {
        BundleContents bundleContents = stack.a(DataComponents.F);
        if (bundleContents != null) {
            return d.add(bundleContents.e());
        }
        List list = stack.a(DataComponents.ad, List.of());
        if (!list.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction((int)1, (int)stack.j());
    }

    public ItemStack a(int index) {
        return this.f.get(index);
    }

    public Stream<ItemStack> a() {
        return this.f.stream().map(ItemStack::s);
    }

    public Iterable<ItemStack> b() {
        return this.f;
    }

    public Iterable<ItemStack> c() {
        return Lists.transform(this.f, ItemStack::s);
    }

    public int d() {
        return this.f.size();
    }

    public Fraction e() {
        return this.g;
    }

    public boolean f() {
        return this.f.isEmpty();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BundleContents) {
            BundleContents bundleContents = (BundleContents)object;
            return this.g.equals((Object)bundleContents.g) && ItemStack.a(this.f, bundleContents.f);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ItemStack.a(this.f);
    }

    @Override
    public String toString() {
        return "BundleContents" + String.valueOf(this.f);
    }

    public static class a {
        private final List<ItemStack> a;
        private Fraction b;

        public a(BundleContents base) {
            this.a = new ArrayList<ItemStack>(base.f);
            this.b = base.g;
        }

        public a a() {
            this.a.clear();
            this.b = Fraction.ZERO;
            return this;
        }

        private int b(ItemStack stack) {
            if (!stack.k()) {
                return -1;
            }
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                if (!ItemStack.c(this.a.get(i2), stack)) continue;
                return i2;
            }
            return -1;
        }

        private int c(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.b);
            return Math.max(fraction.divideBy(BundleContents.a(stack)).intValue(), 0);
        }

        public int a(ItemStack stack) {
            if (stack.e() || !stack.g().ar_()) {
                return 0;
            }
            int i2 = Math.min(stack.H(), this.c(stack));
            if (i2 == 0) {
                return 0;
            }
            this.b = this.b.add(BundleContents.a(stack).multiplyBy(Fraction.getFraction((int)i2, (int)1)));
            int j2 = this.b(stack);
            if (j2 != -1) {
                ItemStack itemStack = this.a.remove(j2);
                ItemStack itemStack2 = itemStack.c(itemStack.H() + i2);
                stack.h(i2);
                this.a.add(0, itemStack2);
            } else {
                this.a.add(0, stack.a(i2));
            }
            return i2;
        }

        public int a(Slot slot, EntityHuman player) {
            ItemStack itemStack = slot.g();
            int i2 = this.c(itemStack);
            return this.a(slot.b(itemStack.H(), i2, player));
        }

        @Nullable
        public ItemStack b() {
            if (this.a.isEmpty()) {
                return null;
            }
            ItemStack itemStack = this.a.remove(0).s();
            this.b = this.b.subtract(BundleContents.a(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.H(), (int)1)));
            return itemStack;
        }

        public Fraction c() {
            return this.b;
        }

        public BundleContents d() {
            return new BundleContents(List.copyOf(this.a), this.b);
        }
    }
}

