/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.TileEntitySkull;

public record ResolvableProfile(Optional<String> c, Optional<UUID> d, PropertyMap e, GameProfile f) {
    private static final Codec<ResolvableProfile> g = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.w.optionalFieldOf("name").forGetter(ResolvableProfile::c), (App)UUIDUtil.a.optionalFieldOf("id").forGetter(ResolvableProfile::d), (App)UUIDUtil.d.lenientOptionalFieldOf("Id").forGetter($ -> Optional.empty()), (App)ExtraCodecs.v.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(ResolvableProfile::e)).apply((Applicative)instance, (s2, uuid, uuid2, propertyMap) -> new ResolvableProfile((Optional<String>)s2, uuid2.or(() -> uuid), (PropertyMap)propertyMap)));
    public static final Codec<ResolvableProfile> a = Codec.withAlternative(g, ExtraCodecs.w, name -> new ResolvableProfile(Optional.of(name), Optional.empty(), new PropertyMap()));
    public static final StreamCodec<ByteBuf, ResolvableProfile> b = StreamCodec.a(ByteBufCodecs.b(16).a(ByteBufCodecs::a), ResolvableProfile::c, UUIDUtil.g.a(ByteBufCodecs::a), ResolvableProfile::d, ByteBufCodecs.t, ResolvableProfile::e, ResolvableProfile::new);

    public ResolvableProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        this(name, id, properties, ResolvableProfile.a(name, id, properties));
    }

    public ResolvableProfile(GameProfile gameProfile) {
        this(Optional.of(gameProfile.getName()), Optional.of(gameProfile.getId()), gameProfile.getProperties(), gameProfile);
    }

    public CompletableFuture<ResolvableProfile> a() {
        if (this.b()) {
            return CompletableFuture.completedFuture(this);
        }
        return this.d.isPresent() ? TileEntitySkull.fetchGameProfile(this.d.get(), this.c.orElse(null)).thenApply(optional -> {
            GameProfile gameProfile = optional.orElseGet(() -> new GameProfile(this.d.get(), this.c.orElse("")));
            return new ResolvableProfile(gameProfile);
        }) : TileEntitySkull.a(this.c.orElseThrow()).thenApply(profile -> {
            GameProfile gameProfile = profile.orElseGet(() -> new GameProfile(SystemUtils.e, this.c.get()));
            return new ResolvableProfile(gameProfile);
        });
    }

    private static GameProfile a(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        GameProfile gameProfile = new GameProfile(id.orElse(SystemUtils.e), name.orElse(""));
        gameProfile.getProperties().putAll((Multimap)properties);
        return gameProfile;
    }

    public boolean b() {
        return !this.e.isEmpty() || this.d.isPresent() == this.c.isPresent();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResolvableProfile.class, "name;id;properties;gameProfile", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResolvableProfile.class, "name;id;properties;gameProfile", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResolvableProfile.class, "name;id;properties;gameProfile", "c", "d", "e", "f"}, this, o2);
    }
}

