/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeSerializerCooking<T extends RecipeCooking>
implements RecipeSerializer<T> {
    private final RecipeCooking.a<T> x;
    private final MapCodec<T> y;
    private final StreamCodec<RegistryFriendlyByteBuf, T> z;

    public RecipeSerializerCooking(RecipeCooking.a<T> recipeFactory, int cookingTime) {
        this.x = recipeFactory;
        this.y = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.c), (App)CookingBookCategory.d.fieldOf("category").orElse((Object)CookingBookCategory.c).forGetter(recipe -> recipe.b), (App)RecipeItemStack.d.fieldOf("ingredient").forGetter(recipe -> recipe.d), (App)ItemStack.e.fieldOf("result").forGetter(recipe -> recipe.e), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.f)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)cookingTime).forGetter(recipe -> recipe.g)).apply((Applicative)instance, recipeFactory::create));
        this.z = StreamCodec.a(this::a, this::a);
    }

    @Override
    @Override
    public MapCodec<T> a() {
        return this.y;
    }

    @Override
    @Override
    public StreamCodec<RegistryFriendlyByteBuf, T> b() {
        return this.z;
    }

    private T a(RegistryFriendlyByteBuf buf) {
        String string = buf.p();
        CookingBookCategory cookingBookCategory = buf.b(CookingBookCategory.class);
        RecipeItemStack ingredient = (RecipeItemStack)RecipeItemStack.b.decode(buf);
        ItemStack itemStack = (ItemStack)ItemStack.i.decode(buf);
        float f2 = buf.readFloat();
        int i2 = buf.l();
        return this.x.create(string, cookingBookCategory, ingredient, itemStack, f2, i2);
    }

    private void a(RegistryFriendlyByteBuf buf, T recipe) {
        buf.a(((RecipeCooking)recipe).c);
        buf.a(((RecipeCooking)recipe).f());
        RecipeItemStack.b.encode(buf, ((RecipeCooking)recipe).d);
        ItemStack.i.encode(buf, ((RecipeCooking)recipe).e);
        buf.a(((RecipeCooking)recipe).f);
        buf.c(((RecipeCooking)recipe).g);
    }

    public RecipeCooking a(String group, CookingBookCategory category, RecipeItemStack ingredient, ItemStack result, float experience, int cookingTime) {
        return this.x.create(group, category, ingredient, result, experience, cookingTime);
    }
}

