/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.entity.Entity;

public class BlockBubbleColumn
extends Block
implements IFluidSource {
    public static final MapCodec<BlockBubbleColumn> a = BlockBubbleColumn.b(BlockBubbleColumn::new);
    public static final BlockStateBoolean b = BlockProperties.e;
    private static final int c = 5;

    public MapCodec<BlockBubbleColumn> a() {
        return a;
    }

    public BlockBubbleColumn(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, true));
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        IBlockData blockState = world.a_(pos.d());
        if (blockState.i()) {
            entity.l(state.c(b));
            if (!world.B) {
                WorldServer serverLevel = (WorldServer)world;
                for (int i2 = 0; i2 < 2; ++i2) {
                    serverLevel.a(Particles.am, (double)pos.u() + world.z.j(), (double)(pos.v() + 1), (double)pos.w() + world.z.j(), 1, 0.0, 0.0, 0.0, 1.0);
                    serverLevel.a(Particles.d, (double)pos.u() + world.z.j(), (double)(pos.v() + 1), (double)pos.w() + world.z.j(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            entity.m(state.c(b));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        BlockBubbleColumn.a((GeneratorAccess)world, pos, state, world.a_(pos.e()));
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return FluidTypes.c.a(false);
    }

    public static void b(GeneratorAccess world, BlockPosition pos, IBlockData state) {
        BlockBubbleColumn.a(world, pos, world.a_(pos), state);
    }

    public static void a(GeneratorAccess world, BlockPosition pos, IBlockData water, IBlockData bubbleSource) {
        if (BlockBubbleColumn.m(water)) {
            IBlockData blockState = BlockBubbleColumn.n(bubbleSource);
            world.a(pos, blockState, 2);
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k().c(EnumDirection.b);
            while (BlockBubbleColumn.m(world.a_(mutableBlockPos))) {
                if (!world.a((BlockPosition)mutableBlockPos, blockState, 2)) {
                    return;
                }
                mutableBlockPos.c(EnumDirection.b);
            }
        }
    }

    private static boolean m(IBlockData state) {
        return state.a(Blocks.nd) || state.a(Blocks.G) && state.u().e() >= 8 && state.u().b();
    }

    private static IBlockData n(IBlockData state) {
        if (state.a(Blocks.nd)) {
            return state;
        }
        if (state.a(Blocks.dW)) {
            return (IBlockData)Blocks.nd.o().a(b, false);
        }
        return state.a(Blocks.kJ) ? (IBlockData)Blocks.nd.o().a(b, true) : Blocks.G.o();
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        double d2 = pos.u();
        double e2 = pos.v();
        double f2 = pos.w();
        if (state.c(b).booleanValue()) {
            world.b(Particles.ap, d2 + 0.5, e2 + 0.8, f2, 0.0, 0.0, 0.0);
            if (random.a(200) == 0) {
                world.a(d2, e2, f2, SoundEffects.da, SoundCategory.e, 0.2f + random.i() * 0.2f, 0.9f + random.i() * 0.15f, false);
            }
        } else {
            world.b(Particles.aq, d2 + 0.5, e2, f2 + 0.5, 0.0, 0.04, 0.0);
            world.b(Particles.aq, d2 + (double)random.i(), e2 + (double)random.i(), f2 + (double)random.i(), 0.0, 0.04, 0.0);
            if (random.a(200) == 0) {
                world.a(d2, e2, f2, SoundEffects.cY, SoundCategory.e, 0.2f + random.i() * 0.2f, 0.9f + random.i() * 0.15f, false);
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        if (!state.a(world, pos) || direction == EnumDirection.a || direction == EnumDirection.b && !neighborState.a(Blocks.nd) && BlockBubbleColumn.m(neighborState)) {
            world.a(pos, this, 5);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos.e());
        return blockState.a(Blocks.nd) || blockState.a(Blocks.kJ) || blockState.a(Blocks.dW);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.a();
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.a;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public ItemStack a(@Nullable EntityHuman player, GeneratorAccess world, BlockPosition pos, IBlockData state) {
        world.a(pos, Blocks.a.o(), 11);
        return new ItemStack(Items.qz);
    }

    @Override
    public Optional<SoundEffect> aw_() {
        return FluidTypes.c.j();
    }
}

