/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class BlockCrops
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCrops> d = BlockCrops.b(BlockCrops::new);
    public static final int e = 7;
    public static final BlockStateInteger f = BlockProperties.av;
    private static final VoxelShape[] a = new VoxelShape[]{Block.a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    public MapCodec<? extends BlockCrops> a() {
        return d;
    }

    protected BlockCrops(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(this.b(), 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a[this.g(state)];
    }

    @Override
    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.a(Blocks.cC);
    }

    protected BlockStateInteger b() {
        return f;
    }

    public int c() {
        return 7;
    }

    public int g(IBlockData state) {
        return state.c(this.b());
    }

    public IBlockData b(int age) {
        return (IBlockData)this.o().a(this.b(), age);
    }

    public final boolean h(IBlockData state) {
        return this.g(state) >= this.c();
    }

    @Override
    protected boolean d_(IBlockData state) {
        return !this.h(state);
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        int i2;
        if (world.b(pos, 0) >= 9 && (i2 = this.g(state)) < this.c()) {
            float f2 = BlockCrops.a(this, world, pos);
            int modifier = this == Blocks.kD ? world.spigotConfig.beetrootModifier : (this == Blocks.gt ? world.spigotConfig.carrotModifier : (this == Blocks.gu ? world.spigotConfig.potatoModifier : (this == Blocks.kA ? world.spigotConfig.torchFlowerModifier : world.spigotConfig.wheatModifier)));
            if ((double)random.i() < (double)modifier / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                CraftEventFactory.handleBlockGrowEvent(world, pos, this.b(i2 + 1), 2);
            }
        }
    }

    public void a(World world, BlockPosition pos, IBlockData state) {
        int j2;
        int i2 = this.g(state) + this.a(world);
        if (i2 > (j2 = this.c())) {
            i2 = j2;
        }
        CraftEventFactory.handleBlockGrowEvent(world, pos, this.b(i2), 2);
    }

    protected int a(World world) {
        return MathHelper.a(world.z, 2, 5);
    }

    protected static float a(Block block, IBlockAccess world, BlockPosition pos) {
        boolean flag1;
        float f2 = 1.0f;
        BlockPosition blockposition1 = pos.e();
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                float f1 = 0.0f;
                IBlockData iblockdata = world.a_(blockposition1.b(i2, 0, j2));
                if (iblockdata.a(Blocks.cC)) {
                    f1 = 1.0f;
                    if (iblockdata.c(BlockSoil.b) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != 0 || j2 != 0) {
                    f1 /= 4.0f;
                }
                f2 += f1;
            }
        }
        BlockPosition blockposition2 = pos.f();
        BlockPosition blockposition3 = pos.g();
        BlockPosition blockposition4 = pos.h();
        BlockPosition blockposition5 = pos.i();
        boolean flag = world.a_(blockposition4).a(block) || world.a_(blockposition5).a(block);
        boolean bl = flag1 = world.a_(blockposition2).a(block) || world.a_(blockposition3).a(block);
        if (flag && flag1) {
            f2 /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = world.a_(blockposition4.f()).a(block) || world.a_(blockposition5.f()).a(block) || world.a_(blockposition5.g()).a(block) || world.a_(blockposition4.g()).a(block);
            if (flag2) {
                f2 /= 2.0f;
            }
        }
        return f2;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return BlockCrops.a(world, pos) && super.a(state, world, pos);
    }

    protected static boolean a(IWorldReader world, BlockPosition pos) {
        return world.b(pos, 0) >= 8;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity instanceof EntityRavager && CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.a.o(), !world.ab().b(GameRules.c))) {
            world.a(pos, true, entity);
        }
        super.a(state, world, pos, entity);
    }

    protected IMaterial d() {
        return Items.pv;
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return new ItemStack(this.d());
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return !this.h(state);
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a((World)world, pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

