/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.slf4j.Logger;

public class BlockDispenser
extends BlockTileEntity {
    private static final Logger e = LogUtils.getLogger();
    public static final MapCodec<BlockDispenser> a = BlockDispenser.b(BlockDispenser::new);
    public static final BlockStateDirection b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.A;
    private static final DispenseBehaviorItem f = new DispenseBehaviorItem();
    public static final Map<Item, IDispenseBehavior> d = (Map)SystemUtils.a(new Object2ObjectOpenHashMap(), (? super T object2objectopenhashmap) -> object2objectopenhashmap.defaultReturnValue((Object)f));
    private static final int g = 4;
    public static boolean eventFired = false;

    public MapCodec<? extends BlockDispenser> a() {
        return a;
    }

    public static void a(IMaterial provider, IDispenseBehavior behavior) {
        d.put(provider.r(), behavior);
    }

    public static void a(IMaterial projectile) {
        d.put(projectile.r(), new DispenseBehaviorProjectile(projectile.r()));
    }

    protected BlockDispenser(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.E.b().a(b, EnumDirection.c)).a(c, false));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityDispenser && player.a((TileEntityDispenser)tileentity).isPresent()) {
            if (tileentity instanceof TileEntityDropper) {
                player.a(StatisticList.ac);
            } else {
                player.a(StatisticList.ae);
            }
        }
        return EnumInteractionResult.c;
    }

    public void a(WorldServer world, IBlockData state, BlockPosition pos) {
        TileEntityDispenser tileentitydispenser = world.a(pos, TileEntityTypes.f).orElse(null);
        if (tileentitydispenser == null) {
            e.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)pos);
        } else {
            SourceBlock sourceblock = new SourceBlock(world, pos, state, tileentitydispenser);
            int i2 = tileentitydispenser.a(world.z);
            if (i2 < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(world, pos)) {
                    world.c(1001, pos, 0);
                    world.a(GameEvent.a, pos, GameEvent.a.a(tileentitydispenser.n()));
                }
            } else {
                ItemStack itemstack = tileentitydispenser.a(i2);
                IDispenseBehavior idispensebehavior = this.a((World)world, itemstack);
                if (idispensebehavior != IDispenseBehavior.b) {
                    if (!CraftEventFactory.handleBlockPreDispenseEvent(world, pos, itemstack, i2)) {
                        return;
                    }
                    eventFired = false;
                    tileentitydispenser.a(i2, idispensebehavior.dispense(sourceblock, itemstack));
                }
            }
        }
    }

    protected IDispenseBehavior a(World world, ItemStack stack) {
        return !stack.a(world.J()) ? f : d.get(stack.g());
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1 = world.C(pos) || world.C(pos.d());
        boolean flag2 = state.c(c);
        if (flag1 && !flag2) {
            world.a(pos, (Block)this, 4);
            world.a(pos, (IBlockData)state.a(c, true), 2);
        } else if (!flag1 && flag2) {
            world.a(pos, (IBlockData)state.a(c, false), 2);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        this.a(world, state, pos);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDispenser(pos, state);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.o().a(b, ctx.d().g());
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        InventoryUtils.a(state, newState, world, pos);
        super.a(state, world, pos, newState, moved);
    }

    public static IPosition a(SourceBlock pointer) {
        return BlockDispenser.a(pointer, 0.7, Vec3D.b);
    }

    public static IPosition a(SourceBlock pointer, double facingOffset, Vec3D constantOffset) {
        EnumDirection enumdirection = pointer.d().c(b);
        return pointer.a().b(facingOffset * (double)enumdirection.j() + constantOffset.a(), facingOffset * (double)enumdirection.k() + constantOffset.b(), facingOffset * (double)enumdirection.l() + constantOffset.c());
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }
}

