/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public class BlockDropper
extends BlockDispenser {
    private static final Logger f = LogUtils.getLogger();
    public static final MapCodec<BlockDropper> e = BlockDropper.b(BlockDropper::new);
    private static final IDispenseBehavior g = new DispenseBehaviorItem(true);

    public MapCodec<BlockDropper> a() {
        return e;
    }

    public BlockDropper(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    protected IDispenseBehavior a(World world, net.minecraft.world.item.ItemStack stack) {
        return g;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityDropper(pos, state);
    }

    @Override
    public void a(WorldServer world, IBlockData state, BlockPosition pos) {
        TileEntityDispenser tileentitydispenser = world.a(pos, TileEntityTypes.g).orElse(null);
        if (tileentitydispenser == null) {
            f.warn("Ignoring dispensing attempt for Dropper without matching block entity at {}", (Object)pos);
        } else {
            SourceBlock sourceblock = new SourceBlock(world, pos, state, tileentitydispenser);
            int i2 = tileentitydispenser.a(world.z);
            if (i2 < 0) {
                if (CraftEventFactory.handleBlockFailedDispenseEvent(world, pos)) {
                    world.c(1001, pos, 0);
                }
            } else {
                net.minecraft.world.item.ItemStack itemstack = tileentitydispenser.a(i2);
                if (!itemstack.e()) {
                    net.minecraft.world.item.ItemStack itemstack1;
                    EnumDirection enumdirection = world.a_(pos).c(BlockDispenser.b);
                    IInventory iinventory = TileEntityHopper.a((World)world, pos.a(enumdirection));
                    if (iinventory == null) {
                        if (!CraftEventFactory.handleBlockPreDispenseEvent(world, pos, itemstack, i2)) {
                            return;
                        }
                        itemstack1 = g.dispense(sourceblock, itemstack);
                    } else {
                        CraftItemStack oitemstack = CraftItemStack.asCraftMirror(itemstack.c(1));
                        Inventory destinationInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : iinventory.getOwner().getInventory();
                        InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentitydispenser.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return;
                        }
                        itemstack1 = TileEntityHopper.a((IInventory)tileentitydispenser, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection.g());
                        if (event.getItem().equals((Object)oitemstack) && itemstack1.e()) {
                            itemstack1 = itemstack.s();
                            itemstack1.h(1);
                        } else {
                            itemstack1 = itemstack.s();
                        }
                    }
                    tileentitydispenser.a(i2, itemstack1);
                }
            }
        }
    }
}

