/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockEnchantmentTable
extends BlockTileEntity {
    public static final MapCodec<BlockEnchantmentTable> a = BlockEnchantmentTable.b(BlockEnchantmentTable::new);
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    public static final List<BlockPosition> c = BlockPosition.a(-2, 0, -2, 2, 1, 2).filter(pos -> Math.abs(pos.u()) == 2 || Math.abs(pos.w()) == 2).map(BlockPosition::j).toList();

    @Override
    public MapCodec<BlockEnchantmentTable> a() {
        return a;
    }

    protected BlockEnchantmentTable(BlockBase.Info settings) {
        super(settings);
    }

    public static boolean a(World world, BlockPosition tablePos, BlockPosition providerOffset) {
        return world.a_(tablePos.a(providerOffset)).a(TagsBlock.cw) && world.a_(tablePos.b(providerOffset.u() / 2, providerOffset.v(), providerOffset.w() / 2)).a(TagsBlock.cx);
    }

    @Override
    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        super.a(state, world, pos, random);
        for (BlockPosition blockPos : c) {
            if (random.a(16) != 0 || !BlockEnchantmentTable.a(world, pos, blockPos)) continue;
            world.a(Particles.s, (double)pos.u() + 0.5, (double)pos.v() + 2.0, (double)pos.w() + 0.5, (double)((float)blockPos.u() + random.i()) - 0.5, (double)((float)blockPos.v() - random.i() - 1.0f), (double)((float)blockPos.w() + random.i()) - 0.5);
        }
    }

    @Override
    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnchantTable(pos, state);
    }

    @Override
    @Nullable
    @Override
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.B ? BlockEnchantmentTable.a(type, TileEntityTypes.m, TileEntityEnchantTable::a) : null;
    }

    @Override
    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        player.a(state.b(world, pos));
        return EnumInteractionResult.c;
    }

    @Override
    @Nullable
    @Override
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity instanceof TileEntityEnchantTable) {
            IChatBaseComponent component = ((INamableTileEntity)((Object)blockEntity)).S_();
            return new TileInventory((syncId, inventory, player) -> new ContainerEnchantTable(syncId, inventory, ContainerAccess.a(world, pos)), component);
        }
        return null;
    }

    @Override
    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }
}

