/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> a = BlockEnderPortal.b(BlockEnderPortal::new);
    protected static final VoxelShape b = Block.a(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    public MapCodec<BlockEnderPortal> a() {
        return a;
    }

    protected BlockEnderPortal(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderPortal(pos, state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity.o(false) && VoxelShapes.c(VoxelShapes.a(entity.cK().d(-pos.u(), -pos.v(), -pos.w())), state.j(world, pos), OperatorBoolean.i)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()), PortalType.ENDER);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (!world.B && world.af() == World.j && entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (world.paperConfig().misc.disableEndCredits) {
                    entityplayer.f = true;
                }
                if (!entityplayer.f) {
                    entityplayer.q();
                    return;
                }
            }
            entity.a(this, pos);
        }
    }

    @Override
    public DimensionTransition a(WorldServer world, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        CraftPortalEvent event;
        ResourceKey<World> resourcekey = world.getTypeKey() == WorldDimension.d ? World.h : World.j;
        WorldServer worldserver1 = world.o().a(resourcekey);
        if (worldserver1 == null) {
            return null;
        }
        boolean flag = resourcekey == World.j;
        BlockPosition blockposition1 = flag ? WorldServer.a : worldserver1.V();
        Vec3D vec3d = blockposition1.c();
        float f2 = entity.dE();
        if (flag) {
            EndPlatformFeature.createEndPlatform(worldserver1, BlockPosition.a(vec3d).e(), true, entity);
            f2 = EnumDirection.e.p();
            if (entity instanceof EntityPlayer) {
                vec3d = vec3d.a(0.0, 1.0, 0.0);
            }
        } else {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                return entityplayer.findRespawnPositionAndUseSpawnBlock(false, DimensionTransition.a, PlayerRespawnEvent.RespawnReason.END_PORTAL);
            }
            vec3d = entity.a(worldserver1, blockposition1).c();
        }
        if ((event = entity.callPortalEvent(entity, CraftLocation.toBukkit(vec3d, (org.bukkit.World)worldserver1.getWorld(), f2, entity.dG()), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0)) == null) {
            return null;
        }
        Location to = event.getTo();
        return new DimensionTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3D(to), entity.dr(), to.getYaw(), to.getPitch(), DimensionTransition.b.then(DimensionTransition.c), PlayerTeleportEvent.TeleportCause.END_PORTAL);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        double d0 = (double)pos.u() + random.j();
        double d1 = (double)pos.v() + 0.8;
        double d2 = (double)pos.w() + random.j();
        world.a(Particles.ae, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return ItemStack.l;
    }

    @Override
    protected boolean a(IBlockData state, FluidType fluid) {
        return false;
    }
}

