/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.ticks.TickListPriority;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockRedstoneComparator
extends BlockDiodeAbstract
implements ITileEntity {
    public static final MapCodec<BlockRedstoneComparator> a = BlockRedstoneComparator.b(BlockRedstoneComparator::new);
    public static final BlockStateEnum<BlockPropertyComparatorMode> b = BlockProperties.bd;

    public MapCodec<BlockRedstoneComparator> a() {
        return a;
    }

    public BlockRedstoneComparator(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(BlockFacingHorizontal.aE, EnumDirection.c)).a(BlockDiodeAbstract.d, false)).a(b, BlockPropertyComparatorMode.a));
    }

    @Override
    protected int g(IBlockData state) {
        return 2;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return direction == EnumDirection.a && !this.b(world, neighborPos, neighborState) ? Blocks.a.o() : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected int a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        TileEntity tileentity = world.c_(pos);
        return tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).b() : 0;
    }

    private int e(World world, BlockPosition pos, IBlockData state) {
        int i2 = this.b(world, pos, state);
        if (i2 == 0) {
            return 0;
        }
        int j2 = this.a((SignalGetter)world, pos, state);
        return j2 > i2 ? 0 : (state.c(b) == BlockPropertyComparatorMode.b ? i2 - j2 : i2);
    }

    @Override
    protected boolean a(World world, BlockPosition pos, IBlockData state) {
        int i2 = this.b(world, pos, state);
        if (i2 == 0) {
            return false;
        }
        int j2 = this.a((SignalGetter)world, pos, state);
        return i2 > j2 ? true : i2 == j2 && state.c(b) == BlockPropertyComparatorMode.a;
    }

    @Override
    protected int b(World world, BlockPosition pos, IBlockData state) {
        int i2 = super.b(world, pos, state);
        EnumDirection enumdirection = state.c(BlockFacingHorizontal.aE);
        BlockPosition blockposition1 = pos.a(enumdirection);
        IBlockData iblockdata1 = world.a_(blockposition1);
        if (iblockdata1.n()) {
            i2 = iblockdata1.a(world, blockposition1);
        } else if (i2 < 15 && iblockdata1.g(world, blockposition1)) {
            blockposition1 = blockposition1.a(enumdirection);
            iblockdata1 = world.a_(blockposition1);
            EntityItemFrame entityitemframe = this.a(world, enumdirection, blockposition1);
            int j2 = Math.max(entityitemframe == null ? Integer.MIN_VALUE : entityitemframe.H(), iblockdata1.n() ? iblockdata1.a(world, blockposition1) : Integer.MIN_VALUE);
            if (j2 != Integer.MIN_VALUE) {
                i2 = j2;
            }
        }
        return i2;
    }

    @Nullable
    private EntityItemFrame a(World world, EnumDirection facing, BlockPosition pos) {
        List<EntityItemFrame> list = world.a(EntityItemFrame.class, new AxisAlignedBB(pos.u(), pos.v(), pos.w(), pos.u() + 1, pos.v() + 1, pos.w() + 1), (? super T entityitemframe) -> entityitemframe != null && entityitemframe.cH() == facing);
        return list.size() == 1 ? list.get(0) : null;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        if (!player.fZ().e) {
            return EnumInteractionResult.e;
        }
        float f2 = (state = (IBlockData)state.a(b)).c(b) == BlockPropertyComparatorMode.b ? 0.55f : 0.5f;
        world.a(player, pos, SoundEffects.fr, SoundCategory.e, 0.3f, f2);
        world.a(pos, state, 2);
        this.f(world, pos, state);
        return EnumInteractionResult.a(world.B);
    }

    @Override
    protected void c(World world, BlockPosition pos, IBlockData state) {
        if (!world.P().b(pos, this)) {
            int j2;
            int i2 = this.e(world, pos, state);
            TileEntity tileentity = world.c_(pos);
            int n2 = j2 = tileentity instanceof TileEntityComparator ? ((TileEntityComparator)tileentity).b() : 0;
            if (i2 != j2 || state.c(BlockDiodeAbstract.d).booleanValue() != this.a(world, pos, state)) {
                TickListPriority ticklistpriority = this.b((IBlockAccess)world, pos, state) ? TickListPriority.c : TickListPriority.d;
                world.a(pos, (Block)this, 2, ticklistpriority);
            }
        }
    }

    private void f(World world, BlockPosition pos, IBlockData state) {
        int i2 = this.e(world, pos, state);
        TileEntity tileentity = world.c_(pos);
        int j2 = 0;
        if (tileentity instanceof TileEntityComparator) {
            TileEntityComparator tileentitycomparator = (TileEntityComparator)tileentity;
            j2 = tileentitycomparator.b();
            tileentitycomparator.a(i2);
        }
        if (j2 != i2 || state.c(b) == BlockPropertyComparatorMode.a) {
            boolean flag = this.a(world, pos, state);
            boolean flag1 = state.c(BlockDiodeAbstract.d);
            if (flag1 && !flag) {
                if (CraftEventFactory.callRedstoneChange(world, pos, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                world.a(pos, (IBlockData)state.a(BlockDiodeAbstract.d, false), 2);
            } else if (!flag1 && flag) {
                if (CraftEventFactory.callRedstoneChange(world, pos, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                world.a(pos, (IBlockData)state.a(BlockDiodeAbstract.d, true), 2);
            }
            this.d(world, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        this.f(world, pos, state);
    }

    @Override
    protected boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        super.a(state, world, pos, type, data);
        TileEntity tileentity = world.c_(pos);
        return tileentity != null && tileentity.a_(type, data);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityComparator(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aE, b, BlockDiodeAbstract.d);
    }
}

