/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockTripwire
extends Block {
    public static final MapCodec<BlockTripwire> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.r().fieldOf("hook").forGetter(blocktripwire -> blocktripwire.m), BlockTripwire.u()).apply((Applicative)instance, BlockTripwire::new));
    public static final BlockStateBoolean b = BlockProperties.w;
    public static final BlockStateBoolean c = BlockProperties.a;
    public static final BlockStateBoolean d = BlockProperties.d;
    public static final BlockStateBoolean e = BlockSprawling.b;
    public static final BlockStateBoolean f = BlockSprawling.c;
    public static final BlockStateBoolean g = BlockSprawling.d;
    public static final BlockStateBoolean h = BlockSprawling.e;
    private static final Map<EnumDirection, BlockStateBoolean> k = BlockTall.f;
    protected static final VoxelShape i = Block.a(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int l = 10;
    private final Block m;

    public MapCodec<BlockTripwire> a() {
        return a;
    }

    public BlockTripwire(Block hookBlock, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b().a(b, false)).a(c, false)).a(d, false)).a(e, false)).a(f, false)).a(g, false)).a(h, false));
        this.m = hookBlock;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) != false ? i : j;
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return this.o();
        }
        World world = ctx.q();
        BlockPosition blockposition = ctx.a();
        return (IBlockData)((IBlockData)((IBlockData)((IBlockData)this.o().a(e, this.a(world.a_(blockposition.f()), EnumDirection.c))).a(f, this.a(world.a_(blockposition.i()), EnumDirection.f))).a(g, this.a(world.a_(blockposition.g()), EnumDirection.d))).a(h, this.a(world.a_(blockposition.h()), EnumDirection.e));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        return direction.o().d() ? (IBlockData)state.a(k.get(direction), this.a(neighborState, direction)) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!oldState.a(state.b())) {
            this.a(world, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!moved && !state.a(newState.b())) {
            this.a(world, pos, (IBlockData)state.a(b, true));
        }
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return state;
        }
        if (!world.B && !player.eT().e() && player.eT().a(Items.rV)) {
            world.a(pos, (IBlockData)state.a(d, true), 4);
            world.a((net.minecraft.world.entity.Entity)player, GameEvent.M, pos);
        }
        return super.a(world, pos, state, player);
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        block0: for (EnumDirection enumdirection : new EnumDirection[]{EnumDirection.d, EnumDirection.e}) {
            for (int k2 = 1; k2 < 42; ++k2) {
                BlockPosition blockposition1 = pos.a(enumdirection, k2);
                IBlockData iblockdata1 = world.a_(blockposition1);
                if (iblockdata1.a(this.m)) {
                    if (iblockdata1.c(BlockTripwireHook.b) != enumdirection.g()) continue block0;
                    BlockTripwireHook.a(world, blockposition1, iblockdata1, false, true, k2, state);
                    continue block0;
                }
                if (!iblockdata1.a(this)) continue block0;
            }
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.B && !state.c(b).booleanValue()) {
            this.a(world, pos);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (GlobalConfiguration.get().blockUpdates.disableTripwireUpdates) {
            return;
        }
        if (world.a_(pos).c(b).booleanValue()) {
            this.a(world, pos);
        }
    }

    private void a(World world, BlockPosition pos) {
        IBlockData iblockdata = world.a_(pos);
        boolean flag = iblockdata.c(b);
        boolean flag1 = false;
        List<net.minecraft.world.entity.Entity> list = world.a_(null, iblockdata.j(world, pos).a().a(pos));
        if (!list.isEmpty()) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (entity.r_()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag != flag1 && flag1 && iblockdata.c(c).booleanValue()) {
            CraftWorld bworld = world.getWorld();
            PluginManager manager = world.getCraftServer().getPluginManager();
            org.bukkit.block.Block block = bworld.getBlockAt(pos.u(), pos.v(), pos.w());
            boolean allowed = false;
            for (net.minecraft.world.entity.Entity object : list) {
                PlayerInteractEvent cancellable;
                if (object == null) continue;
                if (object instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)object, Action.PHYSICAL, pos, null, null, null);
                } else {
                    if (!(object instanceof net.minecraft.world.entity.Entity)) continue;
                    cancellable = new EntityInteractEvent((Entity)object.getBukkitEntity(), block);
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return;
            }
        }
        if (flag1 != flag) {
            iblockdata = (IBlockData)iblockdata.a(b, flag1);
            world.a(pos, iblockdata, 3);
            this.a(world, pos, iblockdata);
        }
        if (flag1) {
            world.a(new BlockPosition(pos), (Block)this, 10);
        }
    }

    public boolean a(IBlockData state, EnumDirection facing) {
        return state.a(this.m) ? state.c(BlockTripwireHook.b) == facing.g() : state.a(this);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        switch (rotation) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(e, state.c(g))).a(f, state.c(h))).a(g, state.c(e))).a(h, state.c(f));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(e, state.c(f))).a(f, state.c(g))).a(g, state.c(h))).a(h, state.c(e));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.a(e, state.c(h))).a(f, state.c(e))).a(g, state.c(f))).a(h, state.c(g));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.a(e, state.c(g))).a(g, state.c(e));
            }
            case c: {
                return (IBlockData)((IBlockData)state.a(f, state.c(h))).a(h, state.c(f));
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f, h, g);
    }
}

