/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class LightningRodBlock
extends RodBlock
implements IBlockWaterlogged {
    public static final MapCodec<LightningRodBlock> b = LightningRodBlock.b(LightningRodBlock::new);
    public static final BlockStateBoolean c = BlockProperties.C;
    public static final BlockStateBoolean d = BlockProperties.w;
    private static final int k = 8;
    public static final int e = 128;
    private static final int l = 200;

    public MapCodec<LightningRodBlock> a() {
        return b;
    }

    public LightningRodBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(BlockDirectional.a, EnumDirection.b)).a(c, false)).a(d, false));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluid = ctx.q().b_(ctx.a());
        boolean flag = fluid.a() == FluidTypes.c;
        return (IBlockData)((IBlockData)this.o().a(BlockDirectional.a, ctx.k())).a(c, flag);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(d) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(d) != false && state.c(BlockDirectional.a) == direction ? 15 : 0;
    }

    public void d(IBlockData state, World world, BlockPosition pos) {
        boolean powered = state.c(d);
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, pos), old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        world.a(pos, (IBlockData)state.a(d, true), 3);
        this.e(state, world, pos);
        world.a(pos, (Block)this, 8);
        world.c(3002, pos, state.c(BlockDirectional.a).o().ordinal());
    }

    private void e(IBlockData state, World world, BlockPosition pos) {
        world.a(pos.a(state.c(BlockDirectional.a).g()), this);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        world.a(pos, (IBlockData)state.a(d, false), 3);
        this.e(state, world, pos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        if (world.ac() && (long)world.z.a(200) <= world.Z() % 200L && pos.v() == world.a(HeightMap.Type.b, pos.u(), pos.w()) - 1) {
            ParticleUtils.a(state.c(BlockDirectional.a).o(), world, pos, 0.125, Particles.aT, UniformInt.a(1, 2));
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            if (state.c(d).booleanValue()) {
                this.e(state, world, pos);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!state.a(oldState.b()) && state.c(d).booleanValue() && !world.P().a(pos, this)) {
            world.a(pos, (IBlockData)state.a(d, false), 18);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockDirectional.a, d, c);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }
}

