/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreTileUpdates;
    public Timing tickTimer = MinecraftTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger d;
    private final TileEntityTypes<?> e;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData f;
    private DataComponentMap g = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        this.e = type;
        this.o = pos.j();
        this.a(state);
        this.f = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void a(IBlockData state) {
        if (!this.b(state)) {
            String s2 = this.k();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(state));
        }
    }

    public boolean b(IBlockData state) {
        return this.e.a(state);
    }

    public static BlockPosition b(NBTTagCompound nbt) {
        return new BlockPosition(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World world) {
        this.n = world;
    }

    public boolean m() {
        return this.n != null;
    }

    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = nbt.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        this.a(nbt, registryLookup);
        a.a.parse(registryLookup.a(DynamicOpsNBT.a), (Object)nbt).resultOrPartial(s2 -> d.warn("Failed to load components: {}", s2)).ifPresent(datacomponentmap -> {
            this.g = datacomponentmap;
        });
    }

    public final void d(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        this.a(nbt, registryLookup);
    }

    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
    }

    public final NBTTagCompound b(HolderLookup.a registryLookup) {
        NBTTagCompound nbttagcompound = this.d(registryLookup);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound c(HolderLookup.a registryLookup) {
        NBTTagCompound nbttagcompound = this.d(registryLookup);
        this.c(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound d(HolderLookup.a registryLookup) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, registryLookup);
        a.a.encodeStart(registryLookup.a(DynamicOpsNBT.a), (Object)this.g).resultOrPartial(s2 -> d.warn("Failed to save components: {}", s2)).ifPresent(nbtbase -> nbttagcompound.a((NBTTagCompound)nbtbase));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound e(HolderLookup.a registryLookup) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, registryLookup);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound f(HolderLookup.a registryLookup) {
        NBTTagCompound nbttagcompound = this.e(registryLookup);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public void c(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.r());
        if (minecraftkey == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        nbt.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbt, TileEntityTypes<?> type) {
        nbt.a("id", TileEntityTypes.a(type).toString());
    }

    public void a(ItemStack stack, HolderLookup.a registries) {
        NBTTagCompound nbttagcompound = this.e(registries);
        this.a(nbttagcompound);
        ItemBlock.a(stack, this.r(), nbttagcompound);
        stack.b(this.s());
    }

    private void d(NBTTagCompound nbt) {
        this.c(nbt);
        nbt.a("x", this.o.u());
        nbt.a("y", this.o.v());
        nbt.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound nbt, HolderLookup.a registryLookup) {
        String s2 = nbt.l("id");
        MinecraftKey minecraftkey = MinecraftKey.c(s2);
        if (minecraftkey == null) {
            d.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.j.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(pos, state);
            }
            catch (Throwable throwable) {
                d.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.c(nbt, registryLookup);
                return tileentity;
            }
            catch (Throwable throwable) {
                d.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            d.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.n != null) {
            if (ignoreTileUpdates) {
                return;
            }
            TileEntity.a(this.n, this.o, this.f);
        }
    }

    protected static void a(World world, BlockPosition pos, IBlockData state) {
        world.q(pos);
        if (!state.i()) {
            world.c(pos, state.b());
        }
    }

    public BlockPosition aD_() {
        return this.o;
    }

    public IBlockData n() {
        return this.f;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> az_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a registryLookup) {
        return new NBTTagCompound();
    }

    public boolean o() {
        return this.p;
    }

    public void aA_() {
        this.p = true;
    }

    public void p() {
        this.p = false;
    }

    public boolean a_(int type, int data) {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSection) {
        crashReportSection.a("Name", this::k);
        if (this.n != null) {
            IBlockData block = this.n();
            if (block != null) {
                CrashReportSystemDetails.a(crashReportSection, this.n, this.o, block);
            }
            CrashReportSystemDetails.a(crashReportSection, this.n, this.o, this.n.a_(this.o));
        }
    }

    private String k() {
        String s2 = String.valueOf(BuiltInRegistries.j.b(this.r()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public boolean q() {
        return false;
    }

    public TileEntityTypes<?> r() {
        return this.e;
    }

    @Deprecated
    public void c(IBlockData state) {
        this.a(state);
        this.f = state;
    }

    protected void a(b components) {
    }

    public final void a(ItemStack stack) {
        this.a(stack.c(), stack.d());
    }

    public final void a(DataComponentMap defaultComponents, DataComponentPatch components) {
        this.applyComponentsSet(defaultComponents, components);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.O);
        final PatchedDataComponentMap patcheddatacomponentmap = PatchedDataComponentMap.a(datacomponentmap, datacomponentpatch);
        this.a(new b(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<T> type) {
                set.add(type);
                return patcheddatacomponentmap.a(type);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> type, T fallback) {
                set.add(type);
                return patcheddatacomponentmap.a(type, fallback);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.a(set::contains);
        this.g = datacomponentpatch1.e().a();
        set.remove(DataComponents.O);
        return set;
    }

    protected void a(DataComponentMap.a componentMapBuilder) {
    }

    @Deprecated
    public void a(NBTTagCompound nbt) {
    }

    public final DataComponentMap s() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        datacomponentmap_a.a(this.g);
        this.a(datacomponentmap_a);
        return datacomponentmap_a.a();
    }

    public DataComponentMap t() {
        return this.g;
    }

    public void a(DataComponentMap components) {
        this.g = components;
    }

    @Nullable
    public static IChatBaseComponent a(String json, HolderLookup.a registryLookup) {
        try {
            return IChatBaseComponent.ChatSerializer.a(json, registryLookup);
        }
        catch (Exception exception) {
            d.warn("Failed to parse custom name from string '{}', discarding", (Object)json, (Object)exception);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.n == null) {
            return null;
        }
        Block block = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        d = LogUtils.getLogger();
    }

    private static class a {
        public static final Codec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T a(DataComponentType<T> var1);

        public <T> T a(DataComponentType<? extends T> var1, T var2);
    }
}

