/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ChestLock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class TileEntityContainer
extends TileEntity
implements IInventory,
ITileInventory,
INamableTileEntity {
    public ChestLock d = ChestLock.a;
    @Nullable
    public IChatBaseComponent e;

    protected TileEntityContainer(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.a(nbt, registryLookup);
        this.d = ChestLock.b(nbt);
        if (nbt.b("CustomName", 8)) {
            this.e = TileEntityContainer.a(nbt.l("CustomName"), registryLookup);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.b(nbt, registryLookup);
        this.d.a(nbt);
        if (this.e != null) {
            nbt.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.e, registryLookup));
        }
    }

    @Override
    public IChatBaseComponent ah() {
        return this.e != null ? this.e : this.k();
    }

    @Override
    public IChatBaseComponent S_() {
        return this.ah();
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.e;
    }

    protected abstract IChatBaseComponent k();

    public boolean d(EntityHuman player) {
        return TileEntityContainer.canUnlock(player, this.d, this.S_(), this);
    }

    @Deprecated
    @DoNotUse
    public static boolean a(EntityHuman player, ChestLock lock, IChatBaseComponent containerName) {
        return TileEntityContainer.canUnlock(player, lock, containerName, null);
    }

    public static boolean canUnlock(EntityHuman player, ChestLock lock, IChatBaseComponent containerName, @Nullable TileEntity blockEntity) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (blockEntity != null && blockEntity.i() != null && blockEntity.i().c_(blockEntity.aD_()) == blockEntity) {
                CraftBlock block = CraftBlock.at(blockEntity.i(), blockEntity.aD_());
                TranslatableComponent lockedMessage = Component.translatable((String)"container.isLocked", (ComponentLike[])new ComponentLike[]{PaperAdventure.asAdventure(containerName)});
                net.kyori.adventure.sound.Sound lockedSound = net.kyori.adventure.sound.Sound.sound((Sound.Type)Sound.BLOCK_CHEST_LOCKED, (Sound.Source)Sound.Source.BLOCK, (float)1.0f, (float)1.0f);
                BlockLockCheckEvent event = new BlockLockCheckEvent((Block)block, (Player)serverPlayer.getBukkitEntity(), (Component)lockedMessage, lockedSound);
                event.callEvent();
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (event.getResult() == Event.Result.DENY || !player.R_() && !lock.a(event.isUsingCustomKeyItemStack() ? CraftItemStack.asNMSCopy(event.getKeyItem()) : player.eT())) {
                    if (event.getLockedMessage() != null) {
                        event.getPlayer().sendActionBar(event.getLockedMessage());
                    }
                    if (event.getLockedSound() != null) {
                        event.getPlayer().playSound(event.getLockedSound());
                    }
                    return false;
                }
                return true;
            }
        }
        if (!player.R_() && !lock.a(player.eT())) {
            player.a(IChatBaseComponent.a("container.isLocked", containerName), true);
            player.a(SoundEffects.eP, SoundCategory.e, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected abstract NonNullList<ItemStack> j();

    protected abstract void a(NonNullList<ItemStack> var1);

    @Override
    public boolean c() {
        ItemStack itemstack;
        Iterator iterator = this.j().iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).e());
        return false;
    }

    @Override
    public ItemStack a(int slot) {
        return this.j().get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemstack = ContainerUtil.a(this.j(), slot, amount);
        if (!itemstack.e()) {
            this.e();
        }
        return itemstack;
    }

    @Override
    public ItemStack b(int slot) {
        return ContainerUtil.a(this.j(), slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.j().set(slot, stack);
        stack.f(this.e_(stack));
        this.e();
    }

    @Override
    public boolean a(EntityHuman player) {
        return IInventory.a(this, player);
    }

    @Override
    public void a() {
        this.j().clear();
    }

    @Override
    @Nullable
    public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
        return this.d(player) ? this.a(syncId, playerInventory) : null;
    }

    protected abstract Container a(int var1, PlayerInventory var2);

    @Override
    protected void a(TileEntity.b components) {
        super.a(components);
        this.e = components.a(DataComponents.g);
        this.d = components.a(DataComponents.ae, ChestLock.a);
        components.a(DataComponents.ab, ItemContainerContents.a).a(this.j());
    }

    @Override
    protected void a(DataComponentMap.a componentMapBuilder) {
        super.a(componentMapBuilder);
        componentMapBuilder.a(DataComponents.g, this.e);
        if (!this.d.equals(ChestLock.a)) {
            componentMapBuilder.a(DataComponents.ae, this.d);
        }
        componentMapBuilder.a(DataComponents.ab, ItemContainerContents.a(this.j()));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        nbt.r("CustomName");
        nbt.r("Lock");
        nbt.r("Items");
    }

    @Override
    public Location getLocation() {
        if (this.n == null) {
            return null;
        }
        return new Location((World)this.n.getWorld(), (double)this.o.u(), (double)this.o.v(), (double)this.o.w());
    }
}

