/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    public static final String a = "spawn_data";
    private static final String m = "next_mob_spawns_at";
    private static final int n = 20;
    private static final int o = 18000;
    public static MapCodec<TrialSpawnerData> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.lenientOptionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.c), (App)UUIDUtil.b.lenientOptionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.d), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.e), (App)Codec.LONG.lenientOptionalFieldOf(m, (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(trialspawnerdata -> trialspawnerdata.g), (App)MobSpawnerData.b.lenientOptionalFieldOf(a).forGetter(trialspawnerdata -> trialspawnerdata.h), (App)ResourceKey.a(Registries.bc).lenientOptionalFieldOf("ejecting_loot_table").forGetter(trialspawnerdata -> trialspawnerdata.i)).apply((Applicative)instance, TrialSpawnerData::new));
    public final Set<UUID> c = new HashSet<UUID>();
    public final Set<UUID> d = new HashSet<UUID>();
    protected long e;
    protected long f;
    protected int g;
    public Optional<MobSpawnerData> h;
    protected Optional<ResourceKey<LootTable>> i;
    @Nullable
    protected Entity j;
    @Nullable
    private SimpleWeightedRandomList<ItemStack> p;
    protected double k;
    protected double l;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> players, Set<UUID> spawnedMobsAlive, long cooldownEnd, long nextMobSpawnsAt, int totalSpawnedMobs, Optional<MobSpawnerData> spawnData, Optional<ResourceKey<LootTable>> rewardLootTable) {
        this.c.addAll(players);
        this.d.addAll(spawnedMobsAlive);
        this.e = cooldownEnd;
        this.f = nextMobSpawnsAt;
        this.g = totalSpawnedMobs;
        this.h = spawnData;
        this.i = rewardLootTable;
    }

    public void reset(TrialSpawner logic) {
        this.c.clear();
        this.g = 0;
        this.f = 0L;
        this.e = 0L;
        this.d.clear();
        if (!logic.b().h().d()) {
            this.h = Optional.empty();
        }
    }

    public boolean a(TrialSpawner logic, RandomSource random) {
        boolean flag = this.b(logic, random).a().b("id", 8);
        return flag || !logic.b().h().d();
    }

    public boolean a(TrialSpawnerConfig config, int additionalPlayers) {
        return this.g >= config.a(additionalPlayers);
    }

    public boolean b() {
        return this.d.isEmpty();
    }

    public boolean a(WorldServer world, TrialSpawnerConfig config, int additionalPlayers) {
        return world.Z() >= this.f && this.d.size() < config.b(additionalPlayers);
    }

    public int a(BlockPosition pos) {
        if (this.c.isEmpty()) {
            SystemUtils.b("Trial Spawner at " + String.valueOf(pos) + " has no detected players");
        }
        return Math.max(0, this.c.size() - 1);
    }

    public void a(WorldServer world, BlockPosition pos, TrialSpawner logic) {
        boolean flag;
        boolean bl = flag = (pos.a() + world.Z()) % 20L != 0L;
        if (!(flag || logic.i().equals(TrialSpawnerState.f) && logic.e())) {
            boolean flag1;
            List<UUID> list = logic.k().detect(world, logic.l(), pos, logic.h(), true);
            if (!logic.e() && !list.isEmpty()) {
                Optional<Pair<EntityHuman, Holder<MobEffectList>>> optional = TrialSpawnerData.a(world, list);
                optional.ifPresent(pair -> {
                    EntityHuman entityhuman = (EntityHuman)pair.getFirst();
                    if (pair.getSecond() == MobEffects.E) {
                        TrialSpawnerData.a(entityhuman);
                    }
                    world.c(3020, BlockPosition.a(entityhuman.by()), 0);
                    logic.a(world, pos);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!logic.i().equals(TrialSpawnerState.f) || flag1) {
                List<UUID> list1;
                boolean flag2 = logic.f().c.isEmpty();
                List<UUID> list2 = list1 = flag2 ? list : logic.k().detect(world, logic.l(), pos, logic.h(), false);
                if (this.c.addAll(list1)) {
                    this.f = Math.max(world.Z() + 40L, this.f);
                    if (!flag1) {
                        int i2 = logic.e() ? 3019 : 3013;
                        world.c(i2, pos, this.c.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> a(WorldServer world, List<UUID> players) {
        EntityHuman entityhuman = null;
        for (UUID uuid : players) {
            EntityHuman entityhuman1 = world.b(uuid);
            if (entityhuman1 == null) continue;
            Holder<MobEffectList> holder = MobEffects.H;
            if (entityhuman1.b(holder)) {
                return Optional.of(Pair.of((Object)entityhuman1, holder));
            }
            if (!entityhuman1.b(MobEffects.E)) continue;
            entityhuman = entityhuman1;
        }
        return Optional.ofNullable(entityhuman).map(entityhuman2 -> Pair.of((Object)entityhuman2, MobEffects.E));
    }

    public void a(TrialSpawner logic, WorldServer world) {
        Stream stream = this.d.stream();
        Objects.requireNonNull(world);
        stream.map(world::a).forEach(entity -> {
            if (entity != null) {
                world.c(3012, entity.do(), TrialSpawner.a.a.a());
                if (entity instanceof EntityInsentient) {
                    EntityInsentient entityinsentient = (EntityInsentient)entity;
                    entityinsentient.fQ();
                }
                entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!logic.d().h().d()) {
            this.h = Optional.empty();
        }
        this.g = 0;
        this.d.clear();
        this.f = world.Z() + (long)logic.d().g();
        logic.j();
        this.e = world.Z() + logic.d().a();
    }

    private static void a(EntityHuman player) {
        MobEffect mobeffect = player.c(MobEffects.E);
        if (mobeffect != null) {
            int i2 = mobeffect.e() + 1;
            int j2 = 18000 * i2;
            player.e(MobEffects.E);
            player.b(new MobEffect(MobEffects.H, j2, 0));
        }
    }

    public boolean a(WorldServer world, float f2, int i2) {
        long j2 = this.e - (long)i2;
        return (float)world.Z() >= (float)j2 + f2;
    }

    public boolean b(WorldServer world, float f2, int i2) {
        long j2 = this.e - (long)i2;
        return (float)(world.Z() - j2) % f2 == 0.0f;
    }

    public boolean a(WorldServer world) {
        return world.Z() >= this.e;
    }

    public void a(TrialSpawner logic, RandomSource random, EntityTypes<?> type) {
        this.b(logic, random).a().a("id", BuiltInRegistries.f.b(type).toString());
    }

    protected MobSpawnerData b(TrialSpawner logic, RandomSource random) {
        if (this.h.isPresent()) {
            return this.h.get();
        }
        SimpleWeightedRandomList<MobSpawnerData> simpleweightedrandomlist = logic.b().h();
        Optional<MobSpawnerData> optional = simpleweightedrandomlist.d() ? this.h : simpleweightedrandomlist.b(random).map(WeightedEntry.b::b);
        this.h = Optional.of(optional.orElseGet(MobSpawnerData::new));
        logic.j();
        return this.h.get();
    }

    @Nullable
    public Entity a(TrialSpawner logic, World world, TrialSpawnerState state) {
        NBTTagCompound nbttagcompound;
        if (!state.d()) {
            return null;
        }
        if (this.j == null && (nbttagcompound = this.b(logic, world.E_()).a()).b("id", 8)) {
            this.j = EntityTypes.a(nbttagcompound, world, Function.identity());
        }
        return this.j;
    }

    public NBTTagCompound a(TrialSpawnerState state) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (state == TrialSpawnerState.c) {
            nbttagcompound.a(m, this.f);
        }
        this.h.ifPresent(mobspawnerdata -> nbttagcompound.a(a, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, mobspawnerdata).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return nbttagcompound;
    }

    public double c() {
        return this.k;
    }

    public double d() {
        return this.l;
    }

    SimpleWeightedRandomList<ItemStack> a(WorldServer world, TrialSpawnerConfig config, BlockPosition pos) {
        long i2;
        LootParams lootparams;
        if (this.p != null) {
            return this.p;
        }
        LootTable loottable = world.o().be().b(config.j());
        ObjectArrayList<ItemStack> objectarraylist = loottable.a(lootparams = new LootParams.a(world).a(LootContextParameterSets.b), i2 = TrialSpawnerData.a(world, pos));
        if (objectarraylist.isEmpty()) {
            return SimpleWeightedRandomList.b();
        }
        SimpleWeightedRandomList.a<ItemStack> simpleweightedrandomlist_a = new SimpleWeightedRandomList.a<ItemStack>();
        for (ItemStack itemstack : objectarraylist) {
            simpleweightedrandomlist_a.a(itemstack.c(1), itemstack.H());
        }
        this.p = simpleweightedrandomlist_a.a();
        return this.p;
    }

    private static long a(WorldServer world, BlockPosition pos) {
        BlockPosition blockposition1 = new BlockPosition(MathHelper.d((float)pos.u() / 30.0f), MathHelper.d((float)pos.v() / 20.0f), MathHelper.d((float)pos.w() / 30.0f));
        return world.C() + blockposition1.a();
    }
}

