/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.slf4j.Logger;

public class VaultBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private final VaultServerData b = new VaultServerData();
    private final VaultSharedData c = new VaultSharedData();
    private final VaultClientData d = new VaultClientData();
    private VaultConfig e = VaultConfig.b;

    public VaultBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.R, pos, state);
    }

    @Override
    @Nullable
    public Packet<PacketListenerPlayOut> az_() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registryLookup) {
        return SystemUtils.a(new NBTTagCompound(), (? super T nbttagcompound) -> nbttagcompound.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, registryLookup)));
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.b(nbt, registryLookup);
        nbt.a("config", VaultBlockEntity.a(VaultConfig.c, this.e, registryLookup));
        nbt.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, registryLookup));
        nbt.a("server_data", VaultBlockEntity.a(VaultServerData.b, this.b, registryLookup));
    }

    private static <T> NBTBase a(Codec<T> codec, T value, HolderLookup.a registries) {
        return (NBTBase)codec.encodeStart(registries.a(DynamicOpsNBT.a), value).getOrThrow();
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        Optional optional;
        Logger logger;
        DataResult dataresult;
        super.a(nbt, registryLookup);
        RegistryOps<NBTBase> dynamicops = registryLookup.a(DynamicOpsNBT.a);
        if (nbt.e("server_data")) {
            dataresult = VaultServerData.b.parse(dynamicops, (Object)nbt.c("server_data"));
            logger = a;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultServerData vaultserverdata = this.b;
            Objects.requireNonNull(this.b);
            optional.ifPresent(vaultserverdata::a);
        }
        if (nbt.e("config")) {
            dataresult = VaultConfig.c.parse(dynamicops, (Object)nbt.c("config"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vaultconfig -> {
                this.e = vaultconfig;
            });
        }
        if (nbt.e("shared_data")) {
            dataresult = VaultSharedData.b.parse(dynamicops, (Object)nbt.c("shared_data"));
            logger = a;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultSharedData vaultshareddata = this.c;
            Objects.requireNonNull(this.c);
            optional.ifPresent(vaultshareddata::a);
        }
    }

    @Nullable
    public VaultServerData b() {
        return this.n != null && !this.n.B ? this.b : null;
    }

    public VaultSharedData c() {
        return this.c;
    }

    public VaultClientData d() {
        return this.d;
    }

    public VaultConfig f() {
        return this.e;
    }

    @VisibleForTesting
    public void a(VaultConfig config) {
        this.e = config;
    }

    public static final class b {
        private static final int a = 14;
        private static final int b = 20;
        private static final int c = 15;

        public static void a(WorldServer world, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData) {
            VaultState vaultstate = state.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world.Z(), vaultstate)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, vaultstate, config, sharedData, pos);
            }
            IBlockData iblockdata1 = state;
            if (world.Z() >= serverData.c() && !state.equals(iblockdata1 = (IBlockData)state.a(VaultBlock.b, vaultstate.a(world, pos, config, serverData, sharedData)))) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, state, iblockdata1, config, sharedData);
            }
            if (serverData.c || sharedData.c) {
                VaultBlockEntity.a(world, pos, state);
                if (sharedData.c) {
                    world.a(pos, state, iblockdata1, 2);
                }
                serverData.c = false;
                sharedData.c = false;
            }
        }

        public static void a(WorldServer world, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, EntityHuman player, ItemStack stack) {
            VaultState vaultstate = state.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, vaultstate)) {
                if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, stack)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, serverData, pos, SoundEffects.AK);
                } else if (serverData.a(player)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, serverData, pos, SoundEffects.AG);
                } else {
                    List<ItemStack> list = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, config, pos, player);
                    if (!list.isEmpty()) {
                        player.b(StatisticList.c.b(stack.g()));
                        stack.a(config.e().H(), (EntityLiving)player);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(world, pos, player, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, state, pos, config, serverData, sharedData, list);
                        serverData.b(player);
                        sharedData.a(world, pos, serverData, config, config.d());
                    }
                }
            }
        }

        static void a(WorldServer world, BlockPosition pos, IBlockData oldState, IBlockData newState, VaultConfig config, VaultSharedData sharedData) {
            VaultState vaultstate = oldState.c(VaultBlock.b);
            VaultState vaultstate1 = newState.c(VaultBlock.b);
            world.a(pos, newState, 3);
            vaultstate.a(world, pos, vaultstate1, config, sharedData, newState.c(VaultBlock.d));
        }

        static void a(WorldServer world, VaultState state, VaultConfig config, VaultSharedData sharedData, BlockPosition pos) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, state)) {
                sharedData.a(ItemStack.l);
            } else {
                ItemStack itemstack = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, config.f().orElse(config.b()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(world, pos, itemstack);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getDisplayItem());
                sharedData.a(itemstack);
            }
        }

        private static ItemStack a(WorldServer world, BlockPosition pos, ResourceKey<LootTable> lootTable) {
            LootParams lootparams;
            LootTable loottable = world.o().be().b(lootTable);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameterSets.l), world.E_());
            return list.isEmpty() ? ItemStack.l : SystemUtils.a(list, world.E_());
        }

        private static void a(WorldServer world, IBlockData state, BlockPosition pos, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, List<ItemStack> itemsToEject) {
            serverData.a(itemsToEject);
            sharedData.a(serverData.f());
            serverData.b(world.Z() + 14L);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(world, pos, state, (IBlockData)state.a(VaultBlock.b, VaultState.c), config, sharedData);
        }

        private static List<ItemStack> a(WorldServer world, VaultConfig config, BlockPosition pos, EntityHuman player) {
            LootTable loottable = world.o().be().b(config.b());
            LootParams lootparams = new LootParams.a(world).a(LootContextParameters.f, Vec3D.b(pos)).a(player.gu()).a(LootContextParameters.a, player).a(LootContextParameterSets.l);
            return loottable.a(lootparams);
        }

        private static boolean a(VaultConfig config, VaultState state) {
            return config.b() != LootTables.a && !config.e().e() && state != VaultState.a;
        }

        private static boolean a(VaultConfig config, ItemStack stack) {
            return ItemStack.c(stack, config.e()) && stack.H() >= config.e().H();
        }

        private static boolean a(long time, VaultState state) {
            return time % 20L == 0L && state == VaultState.b;
        }

        private static void a(WorldServer world, VaultServerData serverData, BlockPosition pos, SoundEffect sound) {
            if (world.Z() >= serverData.a() + 15L) {
                world.a((EntityHuman)null, pos, sound, SoundCategory.e);
                serverData.a(world.Z());
            }
        }
    }

    public static final class a {
        private static final int a = 20;
        private static final float b = 0.5f;
        private static final float c = 0.02f;
        private static final int d = 20;
        private static final int e = 20;

        public static void a(World world, BlockPosition pos, IBlockData state, VaultClientData clientData, VaultSharedData sharedData) {
            clientData.c();
            if (world.Z() % 20L == 0L) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, state, sharedData);
            }
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, sharedData, state.c(VaultBlock.d) != false ? Particles.L : Particles.aJ);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, sharedData);
        }

        public static void a(World world, BlockPosition pos, IBlockData state, VaultSharedData sharedData, ParticleParam particle) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, pos, state, sharedData);
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, randomsource);
                world.a(Particles.ae, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                world.a(particle, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
            }
        }

        public static void a(World world, BlockPosition pos, ParticleParam particle) {
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, randomsource);
                Vec3D vec3d1 = new Vec3D(randomsource.k() * 0.02, randomsource.k() * 0.02, randomsource.k() * 0.02);
                world.a(particle, vec3d.a(), vec3d.b(), vec3d.c(), vec3d1.a(), vec3d1.b(), vec3d1.c());
            }
        }

        private static void a(World world, BlockPosition pos, VaultSharedData sharedData, ParticleParam particle) {
            RandomSource randomsource = world.E_();
            if (randomsource.i() <= 0.5f) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, randomsource);
                world.a(Particles.ae, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData)) {
                    world.a(particle, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void a(World world, Vec3D pos, EntityHuman player) {
            RandomSource randomsource = world.z;
            Vec3D vec3d1 = pos.a(player.dm().b(0.0, player.dk() / 2.0f, 0.0));
            int i2 = MathHelper.a(randomsource, 2, 5);
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d2 = vec3d1.a(randomsource, 1.0f);
                world.a(Particles.ba, pos.a(), pos.b(), pos.c(), vec3d2.a(), vec3d2.b(), vec3d2.c());
            }
        }

        private static void a(World world, BlockPosition pos, IBlockData state, VaultSharedData sharedData) {
            Set<UUID> set = sharedData.d();
            if (!set.isEmpty()) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, state.c(VaultBlock.c));
                for (UUID uuid : set) {
                    EntityHuman entityhuman = world.b(uuid);
                    if (entityhuman == null || !net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, sharedData, entityhuman)) continue;
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, vec3d, entityhuman);
                }
            }
        }

        private static boolean a(BlockPosition pos, VaultSharedData sharedData, EntityHuman player) {
            return player.do().j(pos) <= MathHelper.k(sharedData.e());
        }

        private static void a(World world, BlockPosition pos, VaultSharedData sharedData) {
            RandomSource randomsource;
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData) && (randomsource = world.E_()).i() <= 0.02f) {
                world.a(pos, SoundEffects.AB, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
            }
        }

        public static boolean a(VaultSharedData sharedData) {
            return sharedData.b();
        }

        private static Vec3D a(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6));
        }

        private static Vec3D b(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.1, 0.9), MathHelper.a(random, 0.25, 0.75), MathHelper.a(random, 0.1, 0.9));
        }

        private static Vec3D a(BlockPosition pos, EnumDirection direction) {
            return Vec3D.c(pos).b((double)direction.j() * 0.5, 1.75, (double)direction.l() * 0.5);
        }
    }
}

