/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.starlight.blockstate.StarlightAbstractBlockState;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] aF = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    public final boolean aG;
    protected final float aH;
    protected final boolean aI;
    protected final SoundEffectType aJ;
    protected final float aK;
    protected final float aL;
    protected final float aM;
    protected final boolean aN;
    protected final FeatureFlagSet aO;
    protected final Info aP;
    @Nullable
    protected ResourceKey<LootTable> aQ;

    public BlockBase(Info settings) {
        this.aG = settings.c;
        this.aQ = settings.m;
        this.aH = settings.f;
        this.aI = settings.i;
        this.aJ = settings.d;
        this.aK = settings.j;
        this.aL = settings.k;
        this.aM = settings.l;
        this.aN = settings.D;
        this.aO = settings.E;
        this.aP = settings;
    }

    public Info t() {
        return this.aP;
    }

    protected abstract MapCodec<? extends Block> a();

    protected static <B extends Block> RecordCodecBuilder<B, Info> u() {
        return Info.a.fieldOf("properties").forGetter(BlockBase::t);
    }

    public static <B extends Block> MapCodec<B> b(Function<Info, B> blockFromSettings) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBase.u()).apply((Applicative)instance, blockFromSettings));
    }

    protected void a(IBlockData state, GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
    }

    protected boolean a(IBlockData state, PathMode type) {
        switch (type) {
            case a: {
                return !state.r(BlockAccessAir.a, BlockPosition.c);
            }
            case b: {
                return state.u().a(TagsFluid.a);
            }
            case c: {
                return !state.r(BlockAccessAir.a, BlockPosition.c);
            }
        }
        return false;
    }

    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return state;
    }

    protected boolean a(IBlockData state, IBlockData stateFrom, EnumDirection direction) {
        return false;
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        PacketDebug.a(world, pos);
    }

    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        AsyncCatcher.catchOp("block onPlace");
    }

    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, @Nullable ItemActionContext context) {
        this.b(iblockdata, world, blockposition, iblockdata1, flag);
    }

    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        AsyncCatcher.catchOp("block remove");
        if (state.t() && !state.a(newState.b())) {
            world.o(pos);
        }
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (!state.i() && explosion.j() != Explosion.Effect.d && state.isDestroyable()) {
            Block block = state.b();
            boolean flag = explosion.f() instanceof EntityHuman;
            if (block.a(explosion) && world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                TileEntity tileentity = state.t() ? world.c_(pos) : null;
                LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, ItemStack.l).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, explosion.g());
                if (explosion.yield < 1.0f) {
                    lootparams_a.a(LootContextParameters.j, Float.valueOf(1.0f / explosion.yield));
                }
                state.a(worldserver, pos, ItemStack.l, flag);
                state.a(lootparams_a).forEach(itemstack -> stackMerger.accept((ItemStack)itemstack, pos));
            }
            world.a(pos, Blocks.a.o(), 3);
            block.a(world, pos, explosion);
        }
    }

    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        return EnumInteractionResult.e;
    }

    protected ItemInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return ItemInteractionResult.d;
    }

    protected boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        return false;
    }

    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.c;
    }

    protected boolean f_(IBlockData state) {
        return false;
    }

    protected boolean e_(IBlockData state) {
        return false;
    }

    protected Fluid b_(IBlockData state) {
        return FluidTypes.a.g();
    }

    protected boolean c_(IBlockData state) {
        return false;
    }

    protected float av_() {
        return 0.25f;
    }

    protected float ax_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet i() {
        return this.aO;
    }

    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return state;
    }

    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state;
    }

    protected boolean a(IBlockData state, BlockActionContext context) {
        return state.r() && (context.n().e() || !context.n().a(this.r())) && (state.isDestroyable() || context.o() != null && context.o().fZ().d);
    }

    protected boolean a(IBlockData state, FluidType fluid) {
        return state.r() || !state.e();
    }

    protected List<ItemStack> a(IBlockData state, LootParams.a builder) {
        ResourceKey<LootTable> resourcekey = this.v();
        if (resourcekey == LootTables.a) {
            return Collections.emptyList();
        }
        LootParams lootparams = builder.a(LootContextParameters.g, state).a(LootContextParameterSets.r);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.o().be().b(resourcekey);
        return loottable.a(lootparams);
    }

    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.a(pos);
    }

    protected VoxelShape f(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.j(world, pos);
    }

    protected VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return this.b(state, world, pos, VoxelShapeCollision.a());
    }

    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return VoxelShapes.a();
    }

    protected int g(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.i(world, pos) ? world.Q() : (state.a(world, pos) ? 0 : 1);
    }

    @Nullable
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        return null;
    }

    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return true;
    }

    protected float d(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return state.r(world, pos) ? 0.2f : 1.0f;
    }

    protected int a(IBlockData state, World world, BlockPosition pos) {
        return 0;
    }

    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return VoxelShapes.b();
    }

    protected VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.aG ? state.j(world, pos) : VoxelShapes.a();
    }

    protected boolean c(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.k(world, pos));
    }

    protected boolean h(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return Block.a(state.c(world, pos));
    }

    protected VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.b(state, world, pos, context);
    }

    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
    }

    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
    }

    protected float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        float f2 = state.h(world, pos);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = player.d(state) ? 30 : 100;
        return player.c(state) / f2 / (float)i2;
    }

    protected void a(IBlockData state, WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
    }

    protected void a_(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
    }

    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Entity entity) {
    }

    protected int b(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return 0;
    }

    public final ResourceKey<LootTable> v() {
        if (this.aQ == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.e.b(this.q());
            this.aQ = ResourceKey.a(Registries.bc, minecraftkey.f("blocks/"));
        }
        return this.aQ;
    }

    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
    }

    protected boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return !Block.a(state.j(world, pos)) && state.u().c();
    }

    protected boolean d_(IBlockData state) {
        return this.aI;
    }

    protected SoundEffectType g_(IBlockData state) {
        return this.aJ;
    }

    public abstract Item r();

    protected abstract Block q();

    public MaterialMapColor w() {
        return this.aP.b.apply(this.q().o());
    }

    public float x() {
        return this.aP.g;
    }

    public static class Info {
        public static final Codec<Info> a = Codec.unit(() -> Info.a());
        Function<IBlockData, MaterialMapColor> b = iblockdata -> MaterialMapColor.a;
        boolean c = true;
        SoundEffectType d = SoundEffectType.f;
        ToIntFunction<IBlockData> e = iblockdata -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        ResourceKey<LootTable> m;
        boolean n = true;
        boolean o;
        boolean p;
        @Deprecated
        boolean q;
        @Deprecated
        boolean r;
        boolean s;
        EnumPistonReaction t = EnumPistonReaction.a;
        boolean u = true;
        BlockPropertyInstrument v = BlockPropertyInstrument.a;
        boolean w;
        e<EntityTypes<?>> x = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.d(iblockaccess, blockposition, EnumDirection.b) && iblockdata.h() < 14;
        f y = (iblockdata, iblockaccess, blockposition) -> iblockdata.r(iblockaccess, blockposition);
        f z;
        f A = this.z = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.r(iblockaccess, blockposition);
        f B = (iblockdata, iblockaccess, blockposition) -> false;
        f C = (iblockdata, iblockaccess, blockposition) -> false;
        boolean D;
        FeatureFlagSet E = FeatureFlags.f;
        @Nullable
        b F;

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase block) {
            Info blockbase_info = Info.b(block);
            Info blockbase_info1 = block.aP;
            blockbase_info.l = blockbase_info1.l;
            blockbase_info.y = blockbase_info1.y;
            blockbase_info.x = blockbase_info1.x;
            blockbase_info.B = blockbase_info1.B;
            blockbase_info.z = blockbase_info1.z;
            blockbase_info.A = blockbase_info1.A;
            blockbase_info.m = blockbase_info1.m;
            return blockbase_info;
        }

        @Deprecated
        public static Info b(BlockBase block) {
            Info blockbase_info = new Info();
            Info blockbase_info1 = block.aP;
            blockbase_info.g = blockbase_info1.g;
            blockbase_info.f = blockbase_info1.f;
            blockbase_info.c = blockbase_info1.c;
            blockbase_info.i = blockbase_info1.i;
            blockbase_info.e = blockbase_info1.e;
            blockbase_info.b = blockbase_info1.b;
            blockbase_info.d = blockbase_info1.d;
            blockbase_info.j = blockbase_info1.j;
            blockbase_info.k = blockbase_info1.k;
            blockbase_info.D = blockbase_info1.D;
            blockbase_info.n = blockbase_info1.n;
            blockbase_info.o = blockbase_info1.o;
            blockbase_info.p = blockbase_info1.p;
            blockbase_info.q = blockbase_info1.q;
            blockbase_info.r = blockbase_info1.r;
            blockbase_info.s = blockbase_info1.s;
            blockbase_info.t = blockbase_info1.t;
            blockbase_info.h = blockbase_info1.h;
            blockbase_info.F = blockbase_info1.F;
            blockbase_info.u = blockbase_info1.u;
            blockbase_info.E = blockbase_info1.E;
            blockbase_info.C = blockbase_info1.C;
            blockbase_info.v = blockbase_info1.v;
            blockbase_info.w = blockbase_info1.w;
            return blockbase_info;
        }

        public Info a(EnumColor color) {
            this.b = iblockdata -> color.e();
            return this;
        }

        public Info a(MaterialMapColor color) {
            this.b = iblockdata -> color;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> mapColorProvider) {
            this.b = mapColorProvider;
            return this;
        }

        public Info b() {
            this.c = false;
            this.n = false;
            return this;
        }

        public Info c() {
            this.n = false;
            return this;
        }

        public Info a(float slipperiness) {
            this.j = slipperiness;
            return this;
        }

        public Info b(float velocityMultiplier) {
            this.k = velocityMultiplier;
            return this;
        }

        public Info c(float jumpVelocityMultiplier) {
            this.l = jumpVelocityMultiplier;
            return this;
        }

        public Info a(SoundEffectType soundGroup) {
            this.d = soundGroup;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> luminance) {
            this.e = luminance;
            return this;
        }

        public Info a(float hardness, float resistance) {
            return this.e(hardness).f(resistance);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float strength) {
            this.a(strength, strength);
            return this;
        }

        public Info e() {
            this.i = true;
            return this;
        }

        public Info f() {
            this.D = true;
            return this;
        }

        public Info g() {
            this.m = LootTables.a;
            return this;
        }

        public Info a(Block source) {
            this.m = source.v();
            return this;
        }

        public Info h() {
            this.p = true;
            return this;
        }

        public Info i() {
            this.q = true;
            return this;
        }

        public Info j() {
            this.s = true;
            return this;
        }

        @Deprecated
        public Info k() {
            this.r = true;
            return this;
        }

        public Info a(EnumPistonReaction pistonBehavior) {
            this.t = pistonBehavior;
            return this;
        }

        public Info l() {
            this.o = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> predicate) {
            this.x = predicate;
            return this;
        }

        public Info a(f predicate) {
            this.y = predicate;
            return this;
        }

        public Info b(f predicate) {
            this.z = predicate;
            return this;
        }

        public Info c(f predicate) {
            this.A = predicate;
            return this;
        }

        public Info d(f predicate) {
            this.B = predicate;
            return this;
        }

        public Info e(f predicate) {
            this.C = predicate;
            return this;
        }

        public Info m() {
            this.h = true;
            return this;
        }

        public Info e(float hardness) {
            this.g = hardness;
            return this;
        }

        public Info f(float resistance) {
            this.f = Math.max(0.0f, resistance);
            return this;
        }

        public Info a(EnumRandomOffset offsetType) {
            this.F = switch (offsetType.ordinal()) {
                case 0 -> null;
                case 1 -> (iblockdata, iblockaccess, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    float f2 = block.av_();
                    double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d0, 0.0, d1);
                };
                case 2 -> (iblockdata, iblockaccess, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.ax_();
                    float f2 = block.av_();
                    double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d1, d0, d2);
                };
                default -> throw new MatchException(null, null);
            };
            return this;
        }

        public Info n() {
            this.u = false;
            return this;
        }

        public Info a(FeatureFlag ... features) {
            this.E = FeatureFlags.d.a(features);
            return this;
        }

        public Info a(BlockPropertyInstrument instrument) {
            this.v = instrument;
            return this;
        }

        public Info o() {
            this.w = true;
            return this;
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData>
    implements StarlightAbstractBlockState,
    CollisionBlockState {
        private final int b;
        private final boolean g;
        private final boolean h;
        private final boolean i;
        @Deprecated
        private final boolean j;
        @Deprecated
        private boolean k;
        private final EnumPistonReaction l;
        private final MaterialMapColor m;
        public final float n;
        private final boolean o;
        private final boolean p;
        private final f q;
        private final f r;
        private final f s;
        private final f t;
        private final f u;
        @Nullable
        private final b v;
        private final boolean w;
        private final BlockPropertyInstrument x;
        private final boolean y;
        @Nullable
        protected Cache a;
        private Fluid z;
        private boolean A;
        private int opacityIfCached;
        private boolean isConditionallyFullOpaque;
        private static final int RANDOM_OFFSET = 704237939;
        private static final EnumDirection[] DIRECTIONS_CACHED = EnumDirection.values();
        private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
        private final int id1 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private final int id2 = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(ID_GENERATOR.getAndIncrement() + 704237939)) + 704237939));
        private boolean occludesFullBlock;
        private boolean emptyCollisionShape;
        private VoxelShape constantCollisionShape;
        private AxisAlignedBB constantAABBCollision;
        private CraftBlockData cachedCraftBlockData;
        protected boolean shapeExceedsCube = true;

        @Override
        public final boolean starlight$isConditionallyFullOpaque() {
            return this.isConditionallyFullOpaque;
        }

        @Override
        public final int starlight$getOpacityIfCached() {
            return this.opacityIfCached;
        }

        private static void initCaches(VoxelShape shape) {
            shape.moonrise$isFullBlock();
            shape.moonrise$occludesFullBlock();
            shape.e();
            if (!shape.c()) {
                shape.a();
            }
        }

        @Override
        public final boolean moonrise$hasCache() {
            return this.a != null;
        }

        @Override
        public final boolean moonrise$occludesFullBlock() {
            return this.occludesFullBlock;
        }

        @Override
        public final boolean moonrise$emptyCollisionShape() {
            return this.emptyCollisionShape;
        }

        @Override
        public final int moonrise$uniqueId1() {
            return this.id1;
        }

        @Override
        public final int moonrise$uniqueId2() {
            return this.id2;
        }

        @Override
        public final VoxelShape moonrise$getConstantCollisionShape() {
            return this.constantCollisionShape;
        }

        @Override
        public final AxisAlignedBB moonrise$getConstantCollisionAABB() {
            return this.constantAABBCollision;
        }

        protected BlockData(Block block, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> propertyMap, MapCodec<IBlockData> codec) {
            super(block, propertyMap, codec);
            this.z = FluidTypes.a.g();
            Info blockbase_info = block.aP;
            this.b = blockbase_info.e.applyAsInt(this.x());
            this.g = block.f_(this.x());
            this.h = blockbase_info.o;
            this.i = blockbase_info.p;
            this.j = blockbase_info.q;
            this.l = blockbase_info.t;
            this.m = blockbase_info.b.apply(this.x());
            this.n = blockbase_info.g;
            this.o = blockbase_info.h;
            this.p = blockbase_info.n;
            this.q = blockbase_info.y;
            this.r = blockbase_info.z;
            this.s = blockbase_info.A;
            this.t = blockbase_info.B;
            this.u = blockbase_info.C;
            this.v = blockbase_info.F;
            this.w = blockbase_info.u;
            this.x = blockbase_info.v;
            this.y = blockbase_info.w;
        }

        public CraftBlockData createCraftBlockData() {
            if (this.cachedCraftBlockData == null) {
                this.cachedCraftBlockData = CraftBlockData.createData(this.x());
            }
            return (CraftBlockData)this.cachedCraftBlockData.clone();
        }

        private boolean D() {
            if (((Block)this.e).aP.s) {
                return true;
            }
            if (((Block)this.e).aP.r) {
                return false;
            }
            if (this.a == null) {
                return false;
            }
            VoxelShape voxelshape = this.a.b;
            if (voxelshape.c()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public void a() {
            this.z = ((Block)this.e).b_(this.x());
            this.A = ((Block)this.e).d_(this.x());
            if (!this.b().p()) {
                this.a = new Cache(this.x());
            }
            this.shapeExceedsCube = this.a == null || this.a.c;
            this.k = this.D();
            this.isConditionallyFullOpaque = this.p & this.g;
            int n2 = this.opacityIfCached = this.a == null || this.isConditionallyFullOpaque ? -1 : this.a.h;
            if (this.a != null) {
                VoxelShape collisionShape = this.a.b;
                try {
                    this.constantCollisionShape = this.b((IBlockAccess)null, (BlockPosition)null, (VoxelShapeCollision)null);
                    this.constantAABBCollision = this.constantCollisionShape == null ? null : this.constantCollisionShape.moonrise$getSingleAABBRepresentation();
                }
                catch (Throwable throwable) {
                    this.constantCollisionShape = null;
                    this.constantAABBCollision = null;
                }
                this.occludesFullBlock = collisionShape.moonrise$occludesFullBlock();
                this.emptyCollisionShape = collisionShape.c();
                BlockData.initCaches(collisionShape);
                if (collisionShape != VoxelShapes.a() && collisionShape != VoxelShapes.b()) {
                    for (EnumDirection direction : DIRECTIONS_CACHED) {
                        VoxelShape shape = VoxelShapes.a(collisionShape, direction);
                        BlockData.initCaches(shape);
                    }
                }
                if (this.a.i != null) {
                    for (VoxelShape shape : this.a.i) {
                        BlockData.initCaches(shape);
                    }
                }
            } else {
                this.occludesFullBlock = false;
                this.emptyCollisionShape = false;
                this.constantCollisionShape = null;
                this.constantAABBCollision = null;
            }
        }

        public Block b() {
            return (Block)this.e;
        }

        public Holder<Block> c() {
            return ((Block)this.e).s();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bs && block != Blocks.mY && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.k;
        }

        public final boolean isDestroyable() {
            return this.b().isDestroyable();
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EntityTypes<?> type) {
            return this.b().aP.x.test(this.x(), world, pos, type);
        }

        public boolean a(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.g : this.b().a_(this.x(), world, pos);
        }

        public int b(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.h : this.b().g(this.x(), world, pos);
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a != null && this.a.i != null ? this.a.i[direction.ordinal()] : VoxelShapes.a(this.c(world, pos), direction);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos) {
            return this.b().f(this.x(), world, pos);
        }

        public final boolean f() {
            return this.shapeExceedsCube;
        }

        public final boolean g() {
            return this.g;
        }

        public final int h() {
            return this.b;
        }

        public final boolean i() {
            return this.h;
        }

        public boolean j() {
            return this.i;
        }

        @Deprecated
        public boolean k() {
            return this.j;
        }

        public MaterialMapColor d(IBlockAccess world, BlockPosition pos) {
            return this.m;
        }

        public IBlockData a(EnumBlockRotation rotation) {
            return this.b().a(this.x(), rotation);
        }

        public IBlockData a(EnumBlockMirror mirror) {
            return this.b().a(this.x(), mirror);
        }

        public EnumRenderType l() {
            return this.b().a_(this.x());
        }

        public boolean e(IBlockAccess world, BlockPosition pos) {
            return this.u.test(this.x(), world, pos);
        }

        public float f(IBlockAccess world, BlockPosition pos) {
            return this.b().d(this.x(), world, pos);
        }

        public boolean g(IBlockAccess world, BlockPosition pos) {
            return this.q.test(this.x(), world, pos);
        }

        public boolean m() {
            return this.b().e_(this.x());
        }

        public int b(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().a(this.x(), world, pos, direction);
        }

        public boolean n() {
            return this.b().c_(this.x());
        }

        public int a(World world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public float h(IBlockAccess world, BlockPosition pos) {
            return this.n;
        }

        public float a(EntityHuman player, IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.x(), player, world, pos);
        }

        public int c(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.b().b(this.x(), world, pos, direction);
        }

        public EnumPistonReaction o() {
            return !this.isDestroyable() ? EnumPistonReaction.c : this.l;
        }

        public boolean i(IBlockAccess world, BlockPosition pos) {
            if (this.a != null) {
                return this.a.a;
            }
            IBlockData iblockdata = this.x();
            return iblockdata.p() ? Block.a(iblockdata.c(world, pos)) : false;
        }

        public final boolean p() {
            return this.p;
        }

        public boolean a(IBlockData state, EnumDirection direction) {
            return this.b().a(this.x(), state, direction);
        }

        public VoxelShape j(IBlockAccess world, BlockPosition pos) {
            return this.a(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().a(this.x(), world, pos, context);
        }

        public VoxelShape k(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.b : this.b(world, pos, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().b(this.x(), world, pos, context);
        }

        public VoxelShape l(IBlockAccess world, BlockPosition pos) {
            return this.b().b_(this.x(), world, pos);
        }

        public VoxelShape c(IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
            return this.b().c(this.x(), world, pos, context);
        }

        public VoxelShape m(IBlockAccess world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity) {
            return this.a(world, pos, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess world, BlockPosition pos, Entity entity, EnumDirection direction) {
            return Block.a(this.b(world, pos, VoxelShapeCollision.a(entity)), direction);
        }

        public Vec3D n(IBlockAccess world, BlockPosition pos) {
            b blockbase_b = this.v;
            return blockbase_b != null ? blockbase_b.evaluate(this.x(), world, pos) : Vec3D.b;
        }

        public boolean q() {
            return this.v != null;
        }

        public boolean a(World world, BlockPosition pos, int type, int data) {
            return this.b().a(this.x(), world, pos, type, data);
        }

        public void a(World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
            this.b().a(this.x(), world, pos, sourceBlock, sourcePos, notify);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags) {
            this.a(world, pos, flags, 512);
        }

        public final void a(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : aF) {
                blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
                world.a(enumdirection.g(), this.x(), blockposition_mutableblockposition, pos, flags, maxUpdateDepth);
            }
        }

        public final void b(GeneratorAccess world, BlockPosition pos, int flags) {
            this.b(world, pos, flags, 512);
        }

        public void b(GeneratorAccess world, BlockPosition pos, int flags, int maxUpdateDepth) {
            this.b().a(this.x(), world, pos, flags, maxUpdateDepth);
        }

        public void a(World world, BlockPosition pos, IBlockData state, boolean notify) {
            this.onPlace(world, pos, state, notify, null);
        }

        public void onPlace(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, @Nullable ItemActionContext context) {
            this.b().onPlace(this.x(), world, blockposition, iblockdata, flag, context);
        }

        public void b(World world, BlockPosition pos, IBlockData state, boolean moved) {
            this.b().a(this.x(), world, pos, state, moved);
        }

        public void a(World world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
            this.b().a(this.x(), world, pos, explosion, stackMerger);
        }

        public void a(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().a(this.x(), world, pos, random);
        }

        public void b(WorldServer world, BlockPosition pos, RandomSource random) {
            this.b().b(this.x(), world, pos, random);
        }

        public void a(World world, BlockPosition pos, Entity entity) {
            this.b().a(this.x(), world, pos, entity);
        }

        public void a(WorldServer world, BlockPosition pos, ItemStack tool, boolean dropExperience) {
            this.b().a(this.x(), world, pos, tool, dropExperience);
            if (dropExperience) {
                this.b().a(world, pos, this.b().getExpDrop(this.x(), world, pos, tool, true));
            }
        }

        public List<ItemStack> a(LootParams.a builder) {
            return this.b().a(this.x(), builder);
        }

        public ItemInteractionResult a(ItemStack stack, World world, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
            return this.b().a(stack, this.x(), world, hit.a(), player, hand, hit);
        }

        public EnumInteractionResult a(World world, EntityHuman player, MovingObjectPositionBlock hit) {
            return this.b().a(this.x(), world, hit.a(), player, hit);
        }

        public void a(World world, BlockPosition pos, EntityHuman player) {
            this.b().a_(this.x(), world, pos, player);
        }

        public boolean o(IBlockAccess world, BlockPosition pos) {
            return this.r.test(this.x(), world, pos);
        }

        public boolean p(IBlockAccess world, BlockPosition pos) {
            return this.s.test(this.x(), world, pos);
        }

        public IBlockData a(EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
            return this.b().a(this.x(), direction, neighborState, world, pos, neighborPos);
        }

        public boolean a(PathMode type) {
            return this.b().a(this.x(), type);
        }

        public boolean a(BlockActionContext context) {
            return this.b().a(this.x(), context);
        }

        public boolean a(FluidType fluid) {
            return this.b().a(this.x(), fluid);
        }

        public boolean r() {
            return this.y;
        }

        public boolean a(IWorldReader world, BlockPosition pos) {
            return this.b().a(this.x(), world, pos);
        }

        public boolean q(IBlockAccess world, BlockPosition pos) {
            return this.t.test(this.x(), world, pos);
        }

        @Nullable
        public ITileInventory b(World world, BlockPosition pos) {
            return this.b().b(this.x(), world, pos);
        }

        @Override
        public boolean a(TagKey<Block> tag) {
            return this.b().s().a(tag);
        }

        @Override
        public boolean a(TagKey<Block> tag, Predicate<BlockData> predicate) {
            return this.a(tag) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> blocks) {
            return blocks.a(this.b().s());
        }

        @Override
        public boolean a(Holder<Block> blockEntry) {
            return this.a(blockEntry.a());
        }

        public Stream<TagKey<Block>> s() {
            return this.b().s().c();
        }

        public boolean t() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> blockEntityType) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.x(), blockEntityType) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        @Override
        public boolean a(ResourceKey<Block> key) {
            return this.b().s().a(key);
        }

        public final Fluid u() {
            return this.z;
        }

        public final boolean v() {
            return this.A;
        }

        public long a(BlockPosition pos) {
            return this.b().a(this.x(), pos);
        }

        public SoundEffectType w() {
            return this.b().g_(this.x());
        }

        public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
            this.b().a(world, state, hit, projectile);
        }

        public boolean d(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
            return this.a(world, pos, direction, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction, EnumBlockSupport shapeType) {
            return this.a != null ? this.a.a(direction, shapeType) : shapeType.a(this.x(), world, pos, direction);
        }

        public boolean r(IBlockAccess world, BlockPosition pos) {
            return this.a != null ? this.a.d : this.b().c(this.x(), world, pos);
        }

        protected abstract IBlockData x();

        public boolean y() {
            return this.o;
        }

        public boolean z() {
            return this.w;
        }

        public BlockPropertyInstrument A() {
            return this.x;
        }

        private static final class Cache {
            private static final EnumDirection[] e = EnumDirection.values();
            private static final int f = EnumBlockSupport.values().length;
            protected final boolean a;
            final boolean g;
            final int h;
            @Nullable
            final VoxelShape[] i;
            protected final VoxelShape b;
            protected final boolean c;
            private final boolean[] j;
            protected final boolean d;

            Cache(IBlockData state) {
                Block block = state.b();
                this.a = state.i(BlockAccessAir.a, BlockPosition.c);
                this.g = block.a_(state, BlockAccessAir.a, BlockPosition.c);
                this.h = block.g(state, BlockAccessAir.a, BlockPosition.c);
                if (!state.p()) {
                    this.i = null;
                } else {
                    this.i = new VoxelShape[e.length];
                    VoxelShape voxelshape = block.f(state, BlockAccessAir.a, BlockPosition.c);
                    EnumDirection[] aenumdirection = e;
                    int i2 = aenumdirection.length;
                    for (int j2 = 0; j2 < i2; ++j2) {
                        EnumDirection enumdirection = aenumdirection[j2];
                        this.i[enumdirection.ordinal()] = VoxelShapes.a(voxelshape, enumdirection);
                    }
                }
                this.b = block.b(state, (IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a());
                if (!this.b.c() && state.q()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.e.b(block)));
                }
                this.c = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.b.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.b.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.j = new boolean[e.length * f];
                for (EnumDirection enumdirection1 : e) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.j[Cache.b((EnumDirection)enumdirection1, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(state, BlockAccessAir.a, BlockPosition.c, enumdirection1);
                    }
                }
                this.d = Block.a(state.k(BlockAccessAir.a, BlockPosition.c));
            }

            public boolean a(EnumDirection direction, EnumBlockSupport shapeType) {
                return this.j[Cache.b(direction, shapeType)];
            }

            private static int b(EnumDirection direction, EnumBlockSupport shapeType) {
                return direction.ordinal() * f + shapeType.ordinal();
            }
        }
    }

    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface b {
        public Vec3D evaluate(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }
}

