/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldBorder {
    public static final double b = 5.9999968E7;
    public static final double c = 2.9999984E7;
    private final List<IWorldBorderListener> a = Lists.newArrayList();
    private double e = 0.2;
    private double f = 5.0;
    private int g = 15;
    private int h = 5;
    private double i;
    private double j;
    int k = 29999984;
    private a l = new d(5.9999968E7);
    public static final c d = new c(0.0, 0.0, 0.2, 5.0, 5, 15, 5.9999968E7, 0L, 0.0);
    public WorldServer world;
    private final BlockPosition.MutableBlockPosition mutPos = new BlockPosition.MutableBlockPosition();

    public boolean a(BlockPosition pos) {
        return this.a(pos.u(), pos.w());
    }

    public boolean a(Vec3D pos) {
        return this.a(pos.c, pos.e);
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        return this.a(chunkPos.d(), chunkPos.e()) && this.a(chunkPos.f(), chunkPos.g());
    }

    public boolean isBlockInBounds(int chunkX, int chunkZ) {
        this.mutPos.d(chunkX, 64, chunkZ);
        return this.a(this.mutPos);
    }

    public boolean isChunkInBounds(int chunkX, int chunkZ) {
        this.mutPos.d((chunkX << 4) + 15, 64, (chunkZ << 4) + 15);
        return this.a(this.mutPos);
    }

    public boolean a(AxisAlignedBB box) {
        return this.a(box.a, box.c, box.d - (double)1.0E-5f, box.f - (double)1.0E-5f);
    }

    private boolean a(double minX, double minZ, double maxX, double maxZ) {
        return this.a(minX, minZ) && this.a(maxX, maxZ);
    }

    public boolean a(double x2, double z2) {
        return this.a(x2, z2, 0.0);
    }

    public boolean a(double x2, double z2, double margin) {
        return x2 >= this.e() - margin && x2 < this.g() + margin && z2 >= this.f() - margin && z2 < this.h() + margin;
    }

    public BlockPosition b(BlockPosition pos) {
        return this.b(pos.u(), pos.v(), pos.w());
    }

    public BlockPosition b(Vec3D pos) {
        return this.b(pos.a(), pos.b(), pos.c());
    }

    public BlockPosition b(double x2, double y2, double z2) {
        return BlockPosition.a(MathHelper.a(x2, this.e(), this.g() - 1.0), y2, MathHelper.a(z2, this.f(), this.h() - 1.0));
    }

    public double a(Entity entity) {
        return this.b(entity.dt(), entity.dz());
    }

    public VoxelShape c() {
        return this.l.m();
    }

    public double b(double x2, double z2) {
        double d2 = z2 - this.f();
        double d3 = this.h() - z2;
        double d4 = x2 - this.e();
        double d5 = this.g() - x2;
        double d6 = Math.min(d4, d5);
        d6 = Math.min(d6, d2);
        return Math.min(d6, d3);
    }

    public boolean a(Entity entity, AxisAlignedBB box) {
        double d0 = Math.max(MathHelper.a(box.b(), box.d()), 1.0);
        return this.a(entity) < d0 * 2.0 && this.a(entity.dt(), entity.dz(), d0);
    }

    public BorderStatus d() {
        return this.l.i();
    }

    public double e() {
        return this.l.a();
    }

    public double f() {
        return this.l.c();
    }

    public double g() {
        return this.l.b();
    }

    public double h() {
        return this.l.d();
    }

    public double a() {
        return this.i;
    }

    public double b() {
        return this.j;
    }

    public void c(double x2, double z2) {
        if (this.world != null) {
            WorldBorderCenterChangeEvent event = new WorldBorderCenterChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), new Location((World)this.world.getWorld(), this.a(), 0.0, this.b()), new Location((World)this.world.getWorld(), x2, 0.0, z2));
            if (!event.callEvent()) {
                return;
            }
            x2 = event.getNewCenter().getX();
            z2 = event.getNewCenter().getZ();
        }
        this.i = x2;
        this.j = z2;
        this.l.k();
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.a(this, x2, z2);
        }
    }

    public double i() {
        return this.l.e();
    }

    public long j() {
        return this.l.g();
    }

    public double k() {
        return this.l.h();
    }

    public void a(double size) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE, this.i(), size, 0L);
            if (!event.callEvent()) {
                return;
            }
            if (event.getType() == WorldBorderBoundsChangeEvent.Type.STARTED_MOVE && event.getDuration() > 0L) {
                this.a(event.getOldSize(), event.getNewSize(), event.getDuration());
                return;
            }
            size = event.getNewSize();
        }
        this.l = new d(size);
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.a(this, size);
        }
    }

    public void a(double fromSize, double toSize, long time) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent.Type type = fromSize == toSize ? WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE : WorldBorderBoundsChangeEvent.Type.STARTED_MOVE;
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), type, fromSize, toSize, time);
            if (!event.callEvent()) {
                return;
            }
            toSize = event.getNewSize();
            time = event.getDuration();
        }
        this.l = fromSize == toSize ? new d(toSize) : new b(fromSize, toSize, time);
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.a(this, fromSize, toSize, time);
        }
    }

    protected List<IWorldBorderListener> l() {
        return Lists.newArrayList(this.a);
    }

    public void a(IWorldBorderListener listener) {
        if (this.a.contains(listener)) {
            return;
        }
        this.a.add(listener);
    }

    public void b(IWorldBorderListener listener) {
        this.a.remove(listener);
    }

    public void a(int maxRadius) {
        this.k = maxRadius;
        this.l.j();
    }

    public int m() {
        return this.k;
    }

    public double n() {
        return this.f;
    }

    public void b(double safeZone) {
        this.f = safeZone;
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.c(this, safeZone);
        }
    }

    public double o() {
        return this.e;
    }

    public void c(double damagePerBlock) {
        this.e = damagePerBlock;
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.b(this, damagePerBlock);
        }
    }

    public double p() {
        return this.l.f();
    }

    public int q() {
        return this.g;
    }

    public void b(int warningTime) {
        this.g = warningTime;
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.a(this, warningTime);
        }
    }

    public int r() {
        return this.h;
    }

    public void c(int warningBlocks) {
        this.h = warningBlocks;
        for (IWorldBorderListener iworldborderlistener : this.l()) {
            iworldborderlistener.b(this, warningBlocks);
        }
    }

    public void s() {
        this.l = this.l.l();
    }

    public c t() {
        return new c(this);
    }

    public void a(c properties) {
        this.c(properties.a(), properties.b());
        this.c(properties.c());
        this.b(properties.d());
        this.c(properties.e());
        this.b(properties.f());
        if (properties.h() > 0L) {
            this.a(properties.g(), properties.i(), properties.h());
        } else {
            this.a(properties.g());
        }
    }

    private class d
    implements a {
        private final double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private VoxelShape g;

        public d(double d0) {
            this.b = d0;
            this.n();
        }

        @Override
        public double a() {
            return this.c;
        }

        @Override
        public double b() {
            return this.e;
        }

        @Override
        public double c() {
            return this.d;
        }

        @Override
        public double d() {
            return this.f;
        }

        @Override
        public double e() {
            return this.b;
        }

        @Override
        public BorderStatus i() {
            return BorderStatus.c;
        }

        @Override
        public double f() {
            return 0.0;
        }

        @Override
        public long g() {
            return 0L;
        }

        @Override
        public double h() {
            return this.b;
        }

        private void n() {
            this.c = MathHelper.a(WorldBorder.this.a() - this.b / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
            this.d = MathHelper.a(WorldBorder.this.b() - this.b / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
            this.e = MathHelper.a(WorldBorder.this.a() + this.b / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
            this.f = MathHelper.a(WorldBorder.this.b() + this.b / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
            this.g = VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a()), Double.NEGATIVE_INFINITY, Math.floor(this.c()), Math.ceil(this.b()), Double.POSITIVE_INFINITY, Math.ceil(this.d())), OperatorBoolean.e);
        }

        @Override
        public void j() {
            this.n();
        }

        @Override
        public void k() {
            this.n();
        }

        @Override
        public a l() {
            return this;
        }

        @Override
        public VoxelShape m() {
            return this.g;
        }
    }

    private static interface a {
        public double a();

        public double b();

        public double c();

        public double d();

        public double e();

        public double f();

        public long g();

        public double h();

        public BorderStatus i();

        public void j();

        public void k();

        public a l();

        public VoxelShape m();
    }

    private class b
    implements a {
        private final double b;
        private final double c;
        private final long d;
        private final long e;
        private final double f;

        b(double d0, double d1, long i2) {
            this.b = d0;
            this.c = d1;
            this.f = i2;
            this.e = SystemUtils.c();
            this.d = this.e + i2;
        }

        @Override
        public double a() {
            return MathHelper.a(WorldBorder.this.a() - this.e() / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
        }

        @Override
        public double c() {
            return MathHelper.a(WorldBorder.this.b() - this.e() / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
        }

        @Override
        public double b() {
            return MathHelper.a(WorldBorder.this.a() + this.e() / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
        }

        @Override
        public double d() {
            return MathHelper.a(WorldBorder.this.b() + this.e() / 2.0, (double)(-WorldBorder.this.k), (double)WorldBorder.this.k);
        }

        @Override
        public double e() {
            double d0 = (double)(SystemUtils.c() - this.e) / this.f;
            return d0 < 1.0 ? MathHelper.d(d0, this.b, this.c) : this.c;
        }

        @Override
        public double f() {
            return Math.abs(this.b - this.c) / (double)(this.d - this.e);
        }

        @Override
        public long g() {
            return this.d - SystemUtils.c();
        }

        @Override
        public double h() {
            return this.c;
        }

        @Override
        public BorderStatus i() {
            return this.c < this.b ? BorderStatus.b : BorderStatus.a;
        }

        @Override
        public void k() {
        }

        @Override
        public void j() {
        }

        @Override
        public a l() {
            a a2;
            if (WorldBorder.this.world != null && this.g() <= 0L) {
                new WorldBorderBoundsChangeFinishEvent((World)WorldBorder.this.world.getWorld(), WorldBorder.this.world.getWorld().getWorldBorder(), this.b, this.c, this.f).callEvent();
            }
            if (this.g() <= 0L) {
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                a2 = worldBorder.new d(this.c);
            } else {
                a2 = this;
            }
            return a2;
        }

        @Override
        public VoxelShape m() {
            return VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a()), Double.NEGATIVE_INFINITY, Math.floor(this.c()), Math.ceil(this.b()), Double.POSITIVE_INFINITY, Math.ceil(this.d())), OperatorBoolean.e);
        }
    }

    public static class c {
        private final double a;
        private final double b;
        private final double c;
        private final double d;
        private final int e;
        private final int f;
        private final double g;
        private final long h;
        private final double i;

        c(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long sizeLerpTime, double sizeLerpTarget) {
            this.a = centerX;
            this.b = centerZ;
            this.c = damagePerBlock;
            this.d = safeZone;
            this.e = warningBlocks;
            this.f = warningTime;
            this.g = size;
            this.h = sizeLerpTime;
            this.i = sizeLerpTarget;
        }

        c(WorldBorder worldBorder) {
            this.a = worldBorder.a();
            this.b = worldBorder.b();
            this.c = worldBorder.o();
            this.d = worldBorder.n();
            this.e = worldBorder.r();
            this.f = worldBorder.q();
            this.g = worldBorder.i();
            this.h = worldBorder.j();
            this.i = worldBorder.k();
        }

        public double a() {
            return this.a;
        }

        public double b() {
            return this.b;
        }

        public double c() {
            return this.c;
        }

        public double d() {
            return this.d;
        }

        public int e() {
            return this.e;
        }

        public int f() {
            return this.f;
        }

        public double g() {
            return this.g;
        }

        public long h() {
            return this.h;
        }

        public double i() {
            return this.i;
        }

        public static c a(DynamicLike<?> dynamic, c properties) {
            double d0 = MathHelper.a(dynamic.get("BorderCenterX").asDouble(properties.a), -2.9999984E7, 2.9999984E7);
            double d1 = MathHelper.a(dynamic.get("BorderCenterZ").asDouble(properties.b), -2.9999984E7, 2.9999984E7);
            double d2 = dynamic.get("BorderSize").asDouble(properties.g);
            long i2 = dynamic.get("BorderSizeLerpTime").asLong(properties.h);
            double d3 = dynamic.get("BorderSizeLerpTarget").asDouble(properties.i);
            double d4 = dynamic.get("BorderSafeZone").asDouble(properties.d);
            double d5 = dynamic.get("BorderDamagePerBlock").asDouble(properties.c);
            int j2 = dynamic.get("BorderWarningBlocks").asInt(properties.e);
            int k2 = dynamic.get("BorderWarningTime").asInt(properties.f);
            return new c(d0, d1, d5, d4, j2, k2, d2, i2, d3);
        }

        public void a(NBTTagCompound nbt) {
            nbt.a("BorderCenterX", this.a);
            nbt.a("BorderCenterZ", this.b);
            nbt.a("BorderSize", this.g);
            nbt.a("BorderSizeLerpTime", this.h);
            nbt.a("BorderSafeZone", this.d);
            nbt.a("BorderDamagePerBlock", this.c);
            nbt.a("BorderSizeLerpTarget", this.i);
            nbt.a("BorderWarningBlocks", (double)this.e);
            nbt.a("BorderWarningTime", (double)this.f);
        }
    }
}

