/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkStorage;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable,
ChunkSystemChunkStorage {
    public static final int d = 1493;
    protected final DataFixer e;
    @Nullable
    private volatile PersistentStructureLegacy b;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RegionFileCache storage;

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.storage;
    }

    public IChunkLoader(RegionStorageInfo storageKey, Path directory, DataFixer dataFixer, boolean dsync) {
        this.e = dataFixer;
        this.storage = new IOWorker((RegionStorageInfo)storageKey, (Path)directory, (boolean)dsync).d;
    }

    public boolean b(ChunkCoordIntPair chunkPos, int checkRadius) {
        return true;
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        int i2 = IChunkLoader.a(nbttagcompound);
        if (i2 == SharedConstants.b().d().c()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            if (i2 < 1493 && (nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, i2, 1493)).p("Level").q("hasLegacyStructureData")) {
                PersistentStructureLegacy persistentstructurelegacy;
                PersistentStructureLegacy persistentStructureLegacy = persistentstructurelegacy = this.a(resourcekey, supplier);
                synchronized (persistentStructureLegacy) {
                    nbttagcompound = persistentstructurelegacy.a(nbttagcompound);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.p("Level").l("Status"));
            }
            IChunkLoader.a(nbttagcompound, resourcekey, optional);
            nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, Math.max(1493, i2), SharedConstants.b().d().c());
            if (stopBelowZero) {
                nbttagcompound.a("Status", BuiltInRegistries.l.b(ChunkStatus.m).toString());
            }
            IChunkLoader.b(nbttagcompound);
            GameProfileSerializer.e(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Updated chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Updated chunk details");
            crashreportsystemdetails.a("Data version", i2);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy a(ResourceKey<WorldDimension> worldKey, Supplier<WorldPersistentData> stateManagerGetter) {
        PersistentStructureLegacy persistentstructurelegacy = this.b;
        if (persistentstructurelegacy == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                persistentstructurelegacy = this.b;
                if (persistentstructurelegacy == null) {
                    this.b = persistentstructurelegacy = PersistentStructureLegacy.a(worldKey, stateManagerGetter.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void a(NBTTagCompound nbt, ResourceKey<WorldDimension> worldKey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> generatorCodecKey) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.a("dimension", worldKey.a().toString());
        generatorCodecKey.ifPresent(resourcekey1 -> nbttagcompound1.a("generator", resourcekey1.a().toString()));
        nbt.a("__context", nbttagcompound1);
    }

    private static void b(NBTTagCompound nbt) {
        nbt.r("__context");
    }

    public static int a(NBTTagCompound nbt) {
        return GameProfileSerializer.b(nbt, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.a(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, NBTTagCompound nbt) {
        if (nbt != null && !chunkPos.equals(ChunkRegionLoader.getChunkCoordinate(nbt))) {
            String world = this instanceof PlayerChunkMap ? ((PlayerChunkMap)this).s.getWorld().getName() : null;
            throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(chunkPos) + " but compound says coordinate is " + String.valueOf(ChunkRegionLoader.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
        }
        this.e(chunkPos);
        try {
            this.storage.a(chunkPos, nbt);
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void e(ChunkCoordIntPair chunkPos) {
        if (this.b != null) {
            PersistentStructureLegacy persistentStructureLegacy = this.b;
            synchronized (persistentStructureLegacy) {
                this.b.a(chunkPos.a());
            }
        }
    }

    public void o() {
        try {
            this.storage.a();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess p() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.a(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        };
    }

    public RegionStorageInfo q() {
        return this.storage.b();
    }
}

