/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private final AtomicBoolean b = new AtomicBoolean();
    private final ThreadedMailbox<PairedQueue.b> c;
    public final RegionFileCache d;
    private final Map<ChunkCoordIntPair, a> e = Maps.newLinkedHashMap();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> f = new Long2ObjectLinkedOpenHashMap();
    private static final int g = 1024;

    protected IOWorker(RegionStorageInfo storageKey, Path directory, boolean dsync) {
        this.d = new RegionFileCache(storageKey, directory, dsync);
        this.c = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(Priority.values().length), SystemUtils.h(), "IOWorker-" + storageKey.c());
    }

    public boolean a(ChunkCoordIntPair chunkPos, int checkRadius) {
        ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(chunkPos.e - checkRadius, chunkPos.f - checkRadius);
        ChunkCoordIntPair chunkPos3 = new ChunkCoordIntPair(chunkPos.e + checkRadius, chunkPos.f + checkRadius);
        for (int i2 = chunkPos2.h(); i2 <= chunkPos3.h(); ++i2) {
            for (int j2 = chunkPos2.i(); j2 <= chunkPos3.i(); ++j2) {
                BitSet bitSet = this.a(i2, j2).join();
                if (bitSet.isEmpty()) continue;
                ChunkCoordIntPair chunkPos4 = ChunkCoordIntPair.a(i2, j2);
                int k2 = Math.max(chunkPos2.e - chunkPos4.e, 0);
                int l2 = Math.max(chunkPos2.f - chunkPos4.f, 0);
                int m2 = Math.min(chunkPos3.e - chunkPos4.e, 31);
                int n2 = Math.min(chunkPos3.f - chunkPos4.f, 31);
                for (int o2 = k2; o2 <= m2; ++o2) {
                    for (int p2 = l2; p2 <= n2; ++p2) {
                        int q2 = p2 * 32 + o2;
                        if (!bitSet.get(q2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> a(int chunkX, int chunkZ) {
        long l2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.f;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> completableFuture = (CompletableFuture<BitSet>)this.f.getAndMoveToFirst(l2);
            if (completableFuture == null) {
                completableFuture = this.b(chunkX, chunkZ);
                this.f.putAndMoveToFirst(l2, completableFuture);
                if (this.f.size() > 1024) {
                    this.f.removeLast();
                }
            }
            return completableFuture;
        }
    }

    private CompletableFuture<BitSet> b(int chunkX, int chunkZ) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkCoordIntPair chunkPos = ChunkCoordIntPair.a(chunkX, chunkZ);
            ChunkCoordIntPair chunkPos2 = ChunkCoordIntPair.b(chunkX, chunkZ);
            BitSet bitSet = new BitSet();
            ChunkCoordIntPair.a(chunkPos, chunkPos2).forEach(chunkPosx -> {
                NBTTagCompound compoundTag;
                CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector(NBTTagCompound.b, "blending_data"));
                try {
                    this.a((ChunkCoordIntPair)chunkPosx, collectFields).join();
                }
                catch (Exception var7) {
                    a.warn("Failed to scan chunk {}", chunkPosx, (Object)var7);
                    return;
                }
                NBTBase patt0$temp = collectFields.d();
                if (patt0$temp instanceof NBTTagCompound && this.a(compoundTag = (NBTTagCompound)patt0$temp)) {
                    int ix = chunkPosx.k() * 32 + chunkPosx.j();
                    bitSet.set(ix);
                }
            });
            return bitSet;
        }, SystemUtils.g());
    }

    private boolean a(NBTTagCompound nbt) {
        return !nbt.b("DataVersion", 99) || nbt.h("DataVersion") < 3441 || nbt.b("blending_data", 10);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair pos, @Nullable NBTTagCompound nbt) {
        return this.a(() -> {
            a pendingStore = this.e.computeIfAbsent(pos, pos2 -> new a(nbt));
            pendingStore.a = nbt;
            return Either.left(pendingStore.b);
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<NBTTagCompound>> a(ChunkCoordIntPair pos) {
        return this.a(() -> {
            a pendingStore = this.e.get(pos);
            if (pendingStore != null) {
                return Either.left(Optional.ofNullable(pendingStore.a()));
            }
            try {
                NBTTagCompound compoundTag = this.d.a(pos);
                return Either.left(Optional.ofNullable(compoundTag));
            }
            catch (Exception var4) {
                a.warn("Failed to read chunk {}", (Object)pos, (Object)var4);
                return Either.right(var4);
            }
        });
    }

    public CompletableFuture<Void> a(boolean sync) {
        CompletionStage completableFuture = this.a(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.e.values().stream().map(result -> result.b).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return sync ? ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> {
            try {
                this.d.a();
                return Either.left(null);
            }
            catch (Exception var2x) {
                a.warn("Failed to synchronize chunks", (Throwable)var2x);
                return Either.right(var2x);
            }
        })) : ((CompletableFuture)completableFuture).thenCompose(void_ -> this.a(() -> Either.left(null)));
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair pos, StreamTagVisitor scanner) {
        return this.a(() -> {
            try {
                a pendingStore = this.e.get(pos);
                if (pendingStore != null) {
                    if (pendingStore.a != null) {
                        pendingStore.a.b(scanner);
                    }
                } else {
                    this.d.a(pos, scanner);
                }
                return Either.left(null);
            }
            catch (Exception var4) {
                a.warn("Failed to bulk scan chunk {}", (Object)pos, (Object)var4);
                return Either.right(var4);
            }
        });
    }

    private <T> CompletableFuture<T> a(Supplier<Either<T, Exception>> task) {
        return this.c.c(listener -> new PairedQueue.b(Priority.a.ordinal(), () -> this.a(listener, (Supplier)task)));
    }

    private void b() {
        if (!this.e.isEmpty()) {
            Iterator<Map.Entry<ChunkCoordIntPair, a>> iterator = this.e.entrySet().iterator();
            Map.Entry<ChunkCoordIntPair, a> entry = iterator.next();
            iterator.remove();
            this.a(entry.getKey(), entry.getValue());
            this.c();
        }
    }

    private void c() {
        this.c.a(new PairedQueue.b(Priority.b.ordinal(), this::b));
    }

    private void a(ChunkCoordIntPair pos, a result) {
        try {
            this.d.a(pos, result.a);
            result.b.complete(null);
        }
        catch (Exception var4) {
            a.error("Failed to store chunk {}", (Object)pos, (Object)var4);
            result.b.completeExceptionally(var4);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.b.compareAndSet(false, true)) {
            this.c.b((? super Mailbox<Source> listener) -> new PairedQueue.b(Priority.c.ordinal(), () -> listener.a(Unit.a))).join();
            this.c.close();
            try {
                this.d.close();
            }
            catch (Exception var2) {
                a.error("Failed to close storage", (Throwable)var2);
            }
        }
    }

    public RegionStorageInfo a() {
        return this.d.b();
    }

    private /* synthetic */ void a(Mailbox listener, Supplier task) {
        if (!this.b.get()) {
            listener.a((Either)task.get());
        }
        this.c();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority a = new Priority();
        public static final /* enum */ Priority b = new Priority();
        public static final /* enum */ Priority c = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String name) {
            return Enum.valueOf(Priority.class, name);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{a, b, c};
        }

        static {
            d = Priority.a();
        }
    }

    static class a {
        @Nullable
        NBTTagCompound a;
        final CompletableFuture<Void> b = new CompletableFuture();

        public a(@Nullable NBTTagCompound nbt) {
            this.a = nbt;
        }

        @Nullable
        NBTTagCompound a() {
            NBTTagCompound compoundTag = this.a;
            return compoundTag == null ? null : compoundTag.i();
        }
    }
}

