/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class LegacyRandomSource
implements BitRandomSource {
    private static final int d = 48;
    private static final long e = 0xFFFFFFFFFFFFL;
    private static final long f = 25214903917L;
    private static final long g = 11L;
    private final AtomicLong h = new AtomicLong();
    private final MarsagliaPolarGaussian i = new MarsagliaPolarGaussian(this);

    public LegacyRandomSource(long seed) {
        this.b(seed);
    }

    @Override
    @Override
    public RandomSource d() {
        return new LegacyRandomSource(this.g());
    }

    @Override
    @Override
    public PositionalRandomFactory e() {
        return new a(this.g());
    }

    @Override
    @Override
    public void b(long seed) {
        if (!this.h.compareAndSet(this.h.get(), (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.a("LegacyRandomSource", null);
        }
        this.i.a();
    }

    @Override
    @Override
    public int c(int bits) {
        long m2;
        long l2 = this.h.get();
        if (!this.h.compareAndSet(l2, m2 = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
            throw ThreadingDetector.a("LegacyRandomSource", null);
        }
        return (int)(m2 >> 48 - bits);
    }

    @Override
    @Override
    public double k() {
        return this.i.b();
    }

    public static class a
    implements PositionalRandomFactory {
        private final long a;

        public a(long seed) {
            this.a = seed;
        }

        @Override
        @Override
        public RandomSource a(int x2, int y2, int z2) {
            long l2 = MathHelper.b(x2, y2, z2);
            long m2 = l2 ^ this.a;
            return new LegacyRandomSource(m2);
        }

        @Override
        @Override
        public RandomSource a(String seed) {
            int i2 = seed.hashCode();
            return new LegacyRandomSource((long)i2 ^ this.a);
        }

        @Override
        @Override
        public RandomSource a(long seed) {
            return new LegacyRandomSource(seed);
        }

        @Override
        @VisibleForTesting
        @Override
        public void a(StringBuilder info) {
            info.append("LegacyPositionalRandomFactory{").append(this.a).append("}");
        }
    }
}

