/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class CherryFoliagePlacer
extends WorldGenFoilagePlacer {
    public static final MapCodec<CherryFoliagePlacer> a = RecordCodecBuilder.mapCodec(instance -> CherryFoliagePlacer.b(instance).and(instance.group((App)IntProvider.b(4, 16).fieldOf("height").forGetter(foliagePlacer -> foliagePlacer.b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("wide_bottom_layer_hole_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.c)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("corner_hole_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.c)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.h)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.i)))).apply((Applicative)instance, CherryFoliagePlacer::new));
    private final IntProvider b;
    private final float c;
    private final float g;
    private final float h;
    private final float i;

    public CherryFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider height, float wideBottomLayerHoleChance, float cornerHoleChance, float hangingLeavesChance, float hangingLeavesExtensionChance) {
        super(radius, offset);
        this.b = height;
        this.c = wideBottomLayerHoleChance;
        this.g = cornerHoleChance;
        this.h = hangingLeavesChance;
        this.i = hangingLeavesExtensionChance;
    }

    @Override
    @Override
    protected WorldGenFoilagePlacers<?> a() {
        return WorldGenFoilagePlacers.k;
    }

    @Override
    @Override
    protected void a(VirtualLevelReadable world, WorldGenFoilagePlacer.b placer, RandomSource random, WorldGenFeatureTreeConfiguration config, int trunkHeight, WorldGenFoilagePlacer.a treeNode, int foliageHeight, int radius, int offset) {
        boolean bl = treeNode.c();
        BlockPosition blockPos = treeNode.a().b(offset);
        int i2 = radius + treeNode.b() - 1;
        this.a(world, placer, random, config, blockPos, i2 - 2, foliageHeight - 3, bl);
        this.a(world, placer, random, config, blockPos, i2 - 1, foliageHeight - 4, bl);
        for (int j2 = foliageHeight - 5; j2 >= 0; --j2) {
            this.a(world, placer, random, config, blockPos, i2, j2, bl);
        }
        this.a(world, placer, random, config, blockPos, i2, -1, bl, this.h, this.i);
        this.a(world, placer, random, config, blockPos, i2 - 1, -2, bl, this.h, this.i);
    }

    @Override
    @Override
    public int a(RandomSource random, int trunkHeight, WorldGenFeatureTreeConfiguration config) {
        return this.b.a(random);
    }

    @Override
    @Override
    protected boolean a(RandomSource random, int dx, int y2, int dz, int radius, boolean giantTrunk) {
        boolean bl2;
        if (y2 == -1 && (dx == radius || dz == radius) && random.i() < this.c) {
            return true;
        }
        boolean bl = dx == radius && dz == radius;
        boolean bl3 = bl2 = radius > 2;
        if (bl2) {
            return bl || dx + dz > radius * 2 - 2 && random.i() < this.g;
        }
        return bl && random.i() < this.g;
    }
}

