/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> d = DesertPyramidStructure.a(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c config) {
        super(DesertPyramidPiece::new, 21, 21, config);
    }

    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, PiecesContainer pieces) {
        Comparator set = ArraySetSorted.a(BaseBlockPosition::i);
        for (StructurePiece structurepiece : pieces.c()) {
            if (!(structurepiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertpyramidpiece = (DesertPyramidPiece)structurepiece;
            set.addAll(desertpyramidpiece.b());
            DesertPyramidStructure.a(box, world, desertpyramidpiece.c());
        }
        ObjectArrayList objectarraylist = new ObjectArrayList(set.stream().toList());
        RandomSource randomsource1 = RandomSource.a(world.C()).e().a(pieces.b().g());
        SystemUtils.c(objectarraylist, randomsource1);
        int i2 = Math.min(set.size(), randomsource1.b(5, 8));
        for (BlockPosition blockposition : objectarraylist) {
            if (i2 > 0) {
                --i2;
                DesertPyramidStructure.a(box, world, blockposition);
                continue;
            }
            if (!box.b(blockposition)) continue;
            world.a(blockposition, Blocks.I.o(), 2);
        }
    }

    private static void a(StructureBoundingBox box, GeneratorAccessSeed world, BlockPosition pos) {
        if (box.b(pos)) {
            if (world instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)world;
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((IWorldReader)world, pos, Blocks.J.o(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(LootTables.be));
                brushableState.setSeed(pos.a());
                transformerAccess.setCraftBlock(pos, brushableState, 2);
                return;
            }
            world.a(pos, Blocks.J.o(), 2);
            world.a(pos, TileEntityTypes.N).ifPresent(brushableblockentity -> brushableblockentity.a(LootTables.be, pos.a()));
        }
    }

    @Override
    public StructureType<?> e() {
        return StructureType.b;
    }
}

