/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements DensityFunction.d {
    private static final Codec<Double> e = Codec.doubleRange((double)0.001, (double)1000.0);
    private static final MapCodec<BlendedNoise> f = RecordCodecBuilder.mapCodec(instance -> instance.group((App)e.fieldOf("xz_scale").forGetter(blendedNoise -> blendedNoise.p), (App)e.fieldOf("y_scale").forGetter(blendedNoise -> blendedNoise.q), (App)e.fieldOf("xz_factor").forGetter(blendedNoise -> blendedNoise.l), (App)e.fieldOf("y_factor").forGetter(blendedNoise -> blendedNoise.m), (App)Codec.doubleRange((double)1.0, (double)8.0).fieldOf("smear_scale_multiplier").forGetter(blendedNoise -> blendedNoise.n)).apply((Applicative)instance, BlendedNoise::a));
    public static final KeyDispatchDataCodec<BlendedNoise> a = KeyDispatchDataCodec.a(f);
    private final NoiseGeneratorOctaves g;
    private final NoiseGeneratorOctaves h;
    private final NoiseGeneratorOctaves i;
    private final double j;
    private final double k;
    private final double l;
    private final double m;
    private final double n;
    private final double o;
    private final double p;
    private final double q;

    public static BlendedNoise a(double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        return new BlendedNoise(new XoroshiroRandomSource(0L), xzScale, yScale, xzFactor, yFactor, smearScaleMultiplier);
    }

    private BlendedNoise(NoiseGeneratorOctaves lowerInterpolatedNoise, NoiseGeneratorOctaves upperInterpolatedNoise, NoiseGeneratorOctaves interpolationNoise, double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        this.g = lowerInterpolatedNoise;
        this.h = upperInterpolatedNoise;
        this.i = interpolationNoise;
        this.p = xzScale;
        this.q = yScale;
        this.l = xzFactor;
        this.m = yFactor;
        this.n = smearScaleMultiplier;
        this.j = 684.412 * this.p;
        this.k = 684.412 * this.q;
        this.o = lowerInterpolatedNoise.a(this.k);
    }

    @VisibleForTesting
    public BlendedNoise(RandomSource random, double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        this(NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-7, 0)), xzScale, yScale, xzFactor, yFactor, smearScaleMultiplier);
    }

    public BlendedNoise a(RandomSource random) {
        return new BlendedNoise(random, this.p, this.q, this.l, this.m, this.n);
    }

    @Override
    @Override
    public double a(DensityFunction.b pos) {
        double d2 = (double)pos.a() * this.j;
        double e2 = (double)pos.b() * this.k;
        double f2 = (double)pos.c() * this.j;
        double g2 = d2 / this.l;
        double h2 = e2 / this.m;
        double i2 = f2 / this.l;
        double j2 = this.k * this.n;
        double k2 = j2 / this.m;
        double l2 = 0.0;
        double m2 = 0.0;
        double n2 = 0.0;
        boolean bl = true;
        double o2 = 1.0;
        for (int p2 = 0; p2 < 8; ++p2) {
            NoiseGeneratorPerlin improvedNoise = this.i.a(p2);
            if (improvedNoise != null) {
                n2 += improvedNoise.a(NoiseGeneratorOctaves.b(g2 * o2), NoiseGeneratorOctaves.b(h2 * o2), NoiseGeneratorOctaves.b(i2 * o2), k2 * o2, h2 * o2) / o2;
            }
            o2 /= 2.0;
        }
        double q2 = (n2 / 10.0 + 1.0) / 2.0;
        boolean bl2 = q2 >= 1.0;
        boolean bl3 = q2 <= 0.0;
        o2 = 1.0;
        for (int r2 = 0; r2 < 16; ++r2) {
            NoiseGeneratorPerlin improvedNoise3;
            NoiseGeneratorPerlin improvedNoise2;
            double s2 = NoiseGeneratorOctaves.b(d2 * o2);
            double t2 = NoiseGeneratorOctaves.b(e2 * o2);
            double u2 = NoiseGeneratorOctaves.b(f2 * o2);
            double v2 = j2 * o2;
            if (!bl2 && (improvedNoise2 = this.g.a(r2)) != null) {
                l2 += improvedNoise2.a(s2, t2, u2, v2, e2 * o2) / o2;
            }
            if (!bl3 && (improvedNoise3 = this.h.a(r2)) != null) {
                m2 += improvedNoise3.a(s2, t2, u2, v2, e2 * o2) / o2;
            }
            o2 /= 2.0;
        }
        return MathHelper.b(l2 / 512.0, m2 / 512.0, q2) / 128.0;
    }

    @Override
    @Override
    public double a() {
        return -this.b();
    }

    @Override
    @Override
    public double b() {
        return this.o;
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        info.append("BlendedNoise{minLimitNoise=");
        this.g.a(info);
        info.append(", maxLimitNoise=");
        this.h.a(info);
        info.append(", mainNoise=");
        this.i.a(info);
        info.append(String.format(Locale.ROOT, ", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=4, cellHeight=8", 684.412, 684.412, 8.555150000000001, 4.277575000000001)).append('}');
    }

    @Override
    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> c() {
        return a;
    }
}

