/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger f = LogUtils.getLogger();
    public static final LootTable a = new LootTable(LootContextParameterSets.b, Optional.empty(), List.of(), List.of());
    public static final LootContextParameterSet b = LootContextParameterSets.q;
    public static final long c = 0L;
    public static final Codec<LootTable> d = RecordCodecBuilder.create(instance -> instance.group((App)LootContextParameterSets.a.lenientOptionalFieldOf("type", (Object)b).forGetter(loottable -> loottable.g), (App)MinecraftKey.a.optionalFieldOf("random_sequence").forGetter(loottable -> loottable.h), (App)LootSelector.a.listOf().optionalFieldOf("pools", List.of()).forGetter(loottable -> loottable.i), (App)LootItemFunctions.c.listOf().optionalFieldOf("functions", List.of()).forGetter(loottable -> loottable.j)).apply((Applicative)instance, LootTable::new));
    public static final Codec<Holder<LootTable>> e = RegistryFileCodec.a(Registries.bc, d);
    private final LootContextParameterSet g;
    private final Optional<MinecraftKey> h;
    private final List<LootSelector> i;
    private final List<LootItemFunction> j;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> k;
    public CraftLootTable craftLootTable;

    LootTable(LootContextParameterSet type, Optional<MinecraftKey> randomSequenceId, List<LootSelector> pools, List<LootItemFunction> functions) {
        this.g = type;
        this.h = randomSequenceId;
        this.i = pools;
        this.j = functions;
        this.k = LootItemFunctions.a(functions);
    }

    public static Consumer<ItemStack> a(WorldServer world, Consumer<ItemStack> consumer) {
        boolean skipSplitter = world != null && !world.paperConfig().fixes.splitOverstackedLoot;
        return itemstack -> {
            if (itemstack.a(world.J())) {
                if (skipSplitter || itemstack.H() < itemstack.j()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    ItemStack itemstack1;
                    for (int i2 = itemstack.H(); i2 > 0; i2 -= itemstack1.H()) {
                        itemstack1 = itemstack.c(Math.min(itemstack.j(), i2));
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void a(LootParams parameters, Consumer<ItemStack> lootConsumer) {
        this.a(new LootTableInfo.Builder(parameters).a(this.h), lootConsumer);
    }

    public void a(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        LootTableInfo.c<LootTable> loottableinfo_c = LootTableInfo.a(this);
        if (context.b(loottableinfo_c)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.a(this.k, lootConsumer, context);
            for (LootSelector lootselector : this.i) {
                lootselector.a(consumer1, context);
            }
            context.c(loottableinfo_c);
        } else {
            f.warn("Detected infinite loop in loot tables");
        }
    }

    public void a(LootParams parameters, long seed, Consumer<ItemStack> lootConsumer) {
        this.a(new LootTableInfo.Builder(parameters).a(seed).a(this.h), LootTable.a(parameters.a(), lootConsumer));
    }

    public void b(LootParams parameters, Consumer<ItemStack> lootConsumer) {
        this.a(parameters, LootTable.a(parameters.a(), lootConsumer));
    }

    public void b(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        this.a(context, LootTable.a(context.d(), lootConsumer));
    }

    public ObjectArrayList<ItemStack> a(LootParams parameters, RandomSource random) {
        return this.a(new LootTableInfo.Builder(parameters).a(random).a(this.h));
    }

    public ObjectArrayList<ItemStack> a(LootParams parameters, long seed) {
        return this.a(new LootTableInfo.Builder(parameters).a(seed).a(this.h));
    }

    public ObjectArrayList<ItemStack> a(LootParams parameters) {
        return this.a(new LootTableInfo.Builder(parameters).a(this.h));
    }

    private ObjectArrayList<ItemStack> a(LootTableInfo context) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.b(context, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public LootContextParameterSet a() {
        return this.g;
    }

    public void a(LootCollector reporter) {
        int i2;
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            this.i.get(i2).a(reporter.a(".pools[" + i2 + "]"));
        }
        for (i2 = 0; i2 < this.j.size(); ++i2) {
            this.j.get(i2).a(reporter.a(".functions[" + i2 + "]"));
        }
    }

    public void a(IInventory inventory, LootParams parameters, long seed) {
        this.fillInventory(inventory, parameters, seed, false);
    }

    public void fillInventory(IInventory iinventory, LootParams lootparams, long i2, boolean plugin) {
        LootTableInfo loottableinfo = new LootTableInfo.Builder(lootparams).a(i2).a(this.h);
        ObjectArrayList objectarraylist = this.a(loottableinfo);
        RandomSource randomsource = loottableinfo.b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.a(iinventory, randomsource);
        this.a((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                f.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.e()) {
                iinventory.a((int)list.remove(list.size() - 1), ItemStack.l);
                continue;
            }
            iinventory.a((int)list.remove(list.size() - 1), itemstack);
        }
    }

    private void a(ObjectArrayList<ItemStack> drops, int freeSlots, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = drops.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.e()) {
                iterator.remove();
                continue;
            }
            if (itemstack.H() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (freeSlots - drops.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(MathHelper.a(random, 0, list.size() - 1));
            int j2 = MathHelper.a(random, 1, itemstack1.H() / 2);
            ItemStack itemstack2 = itemstack1.a(j2);
            if (itemstack1.H() > 1 && random.h()) {
                list.add(itemstack1);
            } else {
                drops.add((Object)itemstack1);
            }
            if (itemstack2.H() > 1 && random.h()) {
                list.add(itemstack2);
                continue;
            }
            drops.add((Object)itemstack2);
        }
        drops.addAll((Collection)list);
        SystemUtils.c(drops, random);
    }

    private List<Integer> a(IInventory inventory, RandomSource random) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            if (!inventory.a(i2).e()) continue;
            objectarraylist.add((Object)i2);
        }
        SystemUtils.c(objectarraylist, random);
        return objectarraylist;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> b = ImmutableList.builder();
        private LootContextParameterSet c = b;
        private Optional<MinecraftKey> d = Optional.empty();

        public a a(LootSelector.a poolBuilder) {
            this.a.add((Object)poolBuilder.b());
            return this;
        }

        public a a(LootContextParameterSet type) {
            this.c = type;
            return this;
        }

        public a a(MinecraftKey randomSequenceId) {
            this.d = Optional.of(randomSequenceId);
            return this;
        }

        public a a(LootItemFunction.a function) {
            this.b.add((Object)function.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.d, (List<LootSelector>)this.a.build(), (List<LootItemFunction>)this.b.build());
        }
    }
}

