/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSetName> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionSetName.a(instance).and(instance.group((App)ComponentSerialization.a.optionalFieldOf("name").forGetter(function -> function.c), (App)LootTableInfo.EntityTarget.e.optionalFieldOf("entity").forGetter(function -> function.d), (App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.c.optionalFieldOf("target", (Object)net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.a).forGetter(function -> function.e))).apply((Applicative)instance, LootItemFunctionSetName::new));
    private final Optional<IChatBaseComponent> c;
    private final Optional<LootTableInfo.EntityTarget> d;
    private final a e;

    private LootItemFunctionSetName(List<LootItemCondition> conditions, Optional<IChatBaseComponent> name, Optional<LootTableInfo.EntityTarget> entity, a target) {
        super(conditions);
        this.c = name;
        this.d = entity;
        this.e = target;
    }

    @Override
    public LootItemFunctionType<LootItemFunctionSetName> b() {
        return LootItemFunctions.p;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return this.d.map(entity -> Set.of(entity.a())).orElse(Set.of());
    }

    public static UnaryOperator<IChatBaseComponent> a(LootTableInfo context, @Nullable LootTableInfo.EntityTarget sourceEntity) {
        Entity entity;
        if (sourceEntity != null && (entity = context.c(sourceEntity.a())) != null) {
            CommandListenerWrapper commandSourceStack = entity.dg().a(2);
            return textComponent -> {
                try {
                    return ChatComponentUtils.a(commandSourceStack, textComponent, entity, 0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    b.warn("Failed to resolve text component", (Throwable)commandSyntaxException);
                    return textComponent;
                }
            };
        }
        return textComponent -> textComponent;
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        this.c.ifPresent(name -> stack.b(this.e.a(), (IChatBaseComponent)LootItemFunctionSetName.a(context, this.d.orElse(null)).apply((IChatBaseComponent)name)));
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, a target) {
        return LootItemFunctionSetName.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetName((List<LootItemCondition>)conditions, Optional.of(name), Optional.empty(), target));
    }

    public static LootItemFunctionConditional.a<?> a(IChatBaseComponent name, a target, LootTableInfo.EntityTarget entity) {
        return LootItemFunctionSetName.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetName((List<LootItemCondition>)conditions, Optional.of(name), Optional.of(entity), target));
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("custom_name");
        public static final /* enum */ a b = new a("item_name");
        public static final Codec<a> c;
        private final String d;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private a(String id) {
            this.d = id;
        }

        @Override
        @Override
        public String c() {
            return this.d;
        }

        public DataComponentType<IChatBaseComponent> a() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> DataComponents.h;
                case 0 -> DataComponents.g;
            };
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b};
        }

        static {
            e = net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName$a.b();
            c = INamable.a(a::values);
        }
    }
}

