/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCubeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeMergerDisjoint;
import net.minecraft.world.phys.shapes.VoxelShapeMergerIdentical;
import net.minecraft.world.phys.shapes.VoxelShapeMergerList;

public final class VoxelShapes {
    public static final double a = 1.0E-7;
    public static final double b = 1.0E-6;
    private static final VoxelShape d = SystemUtils.a(() -> {
        VoxelShapeBitSet shape = new VoxelShapeBitSet(1, 1, 1);
        ((VoxelShapeDiscrete)shape).c(0, 0, 0);
        return new VoxelShapeArray((VoxelShapeDiscrete)shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE);
    });
    public static final VoxelShape c = VoxelShapes.a(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape e = new VoxelShapeArray((VoxelShapeDiscrete)new VoxelShapeBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    private static final DoubleArrayList[] PARTS_BY_BITS = new DoubleArrayList[]{DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(1)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(2)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(4)), DoubleArrayList.wrap((double[])VoxelShapes.generateCubeParts(8))};

    public static VoxelShape a() {
        return e;
    }

    public static VoxelShape b() {
        return d;
    }

    private static double[] generateCubeParts(int parts) {
        double inc = 1.0 / (double)parts;
        double[] ret = new double[parts + 1];
        double val = 0.0;
        for (int i2 = 0; i2 <= parts; ++i2) {
            ret[i2] = val;
            val += inc;
        }
        return ret;
    }

    public static VoxelShape a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(minX > maxX || minY > maxY || minZ > maxZ)) {
            return VoxelShapes.b(minX, minY, minZ, maxX, maxY, maxZ);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int bitsX = VoxelShapes.a(minX, maxX);
            int bitsY = VoxelShapes.a(minY, maxY);
            int bitsZ = VoxelShapes.a(minZ, maxZ);
            if (bitsX >= 0 && bitsY >= 0 && bitsZ >= 0) {
                if (bitsX == 0 && bitsY == 0 && bitsZ == 0) {
                    return d;
                }
                int sizeX = 1 << bitsX;
                int sizeY = 1 << bitsY;
                int sizeZ = 1 << bitsZ;
                VoxelShapeBitSet shape = VoxelShapeBitSet.a(sizeX, sizeY, sizeZ, (int)Math.round(minX * (double)sizeX), (int)Math.round(minY * (double)sizeY), (int)Math.round(minZ * (double)sizeZ), (int)Math.round(maxX * (double)sizeX), (int)Math.round(maxY * (double)sizeY), (int)Math.round(maxZ * (double)sizeZ));
                return new VoxelShapeArray((VoxelShapeDiscrete)shape, (DoubleList)PARTS_BY_BITS[bitsX], (DoubleList)PARTS_BY_BITS[bitsY], (DoubleList)PARTS_BY_BITS[bitsZ]);
            }
            return new VoxelShapeArray(VoxelShapes.d.a, (DoubleList)(minX == 0.0 && maxX == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minX, maxX})), (DoubleList)(minY == 0.0 && maxY == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minY, maxY})), (DoubleList)(minZ == 0.0 && maxZ == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minZ, maxZ})));
        }
        return e;
    }

    public static VoxelShape a(AxisAlignedBB box) {
        return VoxelShapes.b(box.a, box.b, box.c, box.d, box.e, box.f);
    }

    @VisibleForTesting
    protected static int a(double min, double max) {
        if (!(min < -1.0E-7) && !(max > 1.0000001)) {
            for (int i2 = 0; i2 <= 3; ++i2) {
                boolean bl2;
                int j2 = 1 << i2;
                double d2 = min * (double)j2;
                double e2 = max * (double)j2;
                boolean bl = Math.abs(d2 - (double)Math.round(d2)) < 1.0E-7 * (double)j2;
                boolean bl3 = bl2 = Math.abs(e2 - (double)Math.round(e2)) < 1.0E-7 * (double)j2;
                if (!bl || !bl2) continue;
                return i2;
            }
            return -1;
        }
        return -1;
    }

    protected static long a(int a2, int b2) {
        return (long)a2 * (long)(b2 / IntMath.gcd((int)a2, (int)b2));
    }

    public static VoxelShape a(VoxelShape first, VoxelShape second) {
        return VoxelShapes.a(first, second, OperatorBoolean.o);
    }

    public static VoxelShape a(VoxelShape shape, VoxelShape ... others) {
        int size = others.length;
        if (size == 0) {
            return shape;
        }
        VoxelShape[] tmp = Arrays.copyOf(others, ++size);
        tmp[size - 1] = shape;
        while (size > 1) {
            int newSize = 0;
            for (int i2 = 0; i2 < size; i2 += 2) {
                int next = i2 + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i2];
                    break;
                }
                VoxelShape first = tmp[i2];
                VoxelShape second = tmp[next];
                tmp[newSize++] = VoxelShapes.a(first, second);
            }
            size = newSize;
        }
        return tmp[0];
    }

    public static VoxelShape a(VoxelShape first, VoxelShape second, OperatorBoolean function) {
        return CollisionUtil.joinOptimized(first, second, function);
    }

    public static VoxelShape b(VoxelShape one, VoxelShape two, OperatorBoolean function) {
        return CollisionUtil.joinUnoptimized(one, two, function);
    }

    public static boolean c(VoxelShape shape1, VoxelShape shape2, OperatorBoolean predicate) {
        return CollisionUtil.isJoinNonEmpty(shape1, shape2, predicate);
    }

    private static boolean a(VoxelShapeMerger mergedX, VoxelShapeMerger mergedY, VoxelShapeMerger mergedZ, VoxelShapeDiscrete shape1, VoxelShapeDiscrete shape2, OperatorBoolean predicate) {
        return !mergedX.a((x1, x2, index1) -> mergedY.a((y1, y2, index2) -> mergedZ.a((z1, z2, index3) -> !predicate.apply(shape1.e(x1, y1, z1), shape2.e(x2, y2, z2)))));
    }

    public static double a(EnumDirection.EnumAxis axis, AxisAlignedBB box, Iterable<VoxelShape> shapes, double maxDist) {
        for (VoxelShape voxelShape : shapes) {
            if (Math.abs(maxDist) < 1.0E-7) {
                return 0.0;
            }
            maxDist = voxelShape.a(axis, box, maxDist);
        }
        return maxDist;
    }

    public static boolean a(VoxelShape first, VoxelShape second, EnumDirection direction) {
        boolean secondBlock;
        boolean firstBlock = first == d;
        boolean bl = secondBlock = second == d;
        if (firstBlock & secondBlock) {
            return true;
        }
        if (first.c() | second.c()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        if (newFirst.c()) {
            return false;
        }
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.g());
        if (newSecond.c()) {
            return false;
        }
        return !VoxelShapes.c(newFirst, newSecond, OperatorBoolean.e);
    }

    public static VoxelShape a(VoxelShape shape, EnumDirection direction) {
        return shape.moonrise$getFaceShapeClamped(direction);
    }

    private static boolean mergedMayOccludeBlock(VoxelShape shape1, VoxelShape shape2) {
        AxisAlignedBB bounds1 = shape1.a();
        AxisAlignedBB bounds2 = shape2.a();
        double minX = Math.min(bounds1.a, bounds2.a);
        double minY = Math.min(bounds1.b, bounds2.b);
        double minZ = Math.min(bounds1.c, bounds2.c);
        double maxX = Math.max(bounds1.d, bounds2.d);
        double maxY = Math.max(bounds1.e, bounds2.e);
        double maxZ = Math.max(bounds1.f, bounds2.f);
        return minX <= 1.0E-7 && maxX >= 0.9999999 && minY <= 1.0E-7 && maxY >= 0.9999999 && minZ <= 1.0E-7 && maxZ >= 0.9999999;
    }

    public static boolean b(VoxelShape first, VoxelShape second, EnumDirection direction) {
        boolean secondEmpty;
        if (first.moonrise$occludesFullBlockIfCached() || second.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        if (first.c() & second.c()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.g());
        if (newFirst.moonrise$occludesFullBlockIfCached() || newSecond.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean firstEmpty = newFirst.c();
        if (firstEmpty & (secondEmpty = newSecond.c())) {
            return false;
        }
        if (firstEmpty | secondEmpty) {
            return secondEmpty ? newFirst.moonrise$occludesFullBlock() : newSecond.moonrise$occludesFullBlock();
        }
        if (newFirst == newSecond) {
            return newFirst.moonrise$occludesFullBlock();
        }
        return VoxelShapes.mergedMayOccludeBlock(newFirst, newSecond) && newFirst.moonrise$orUnoptimized(newSecond).moonrise$occludesFullBlock();
    }

    public static boolean b(VoxelShape shape1, VoxelShape shape2) {
        boolean s2Empty;
        if (shape1.moonrise$occludesFullBlockIfCached() || shape2.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean s1Empty = shape1.c();
        if (s1Empty & (s2Empty = shape2.c())) {
            return false;
        }
        if (s1Empty | s2Empty) {
            return s2Empty ? shape1.moonrise$occludesFullBlock() : shape2.moonrise$occludesFullBlock();
        }
        if (shape1 == shape2) {
            return shape1.moonrise$occludesFullBlock();
        }
        return VoxelShapes.mergedMayOccludeBlock(shape1, shape2) && shape1.moonrise$orUnoptimized(shape2).moonrise$occludesFullBlock();
    }

    @VisibleForTesting
    private static VoxelShapeMerger a(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        if (first.getDouble(0) == Double.NEGATIVE_INFINITY && first.getDouble(first.size() - 1) == Double.POSITIVE_INFINITY) {
            return new VoxelShapeMergerList(first, second, includeFirst, includeSecond);
        }
        return VoxelShapes.lessCommonMerge(size, first, second, includeFirst, includeSecond);
    }

    private static VoxelShapeMerger lessCommonMerge(int size, DoubleList first, DoubleList second, boolean includeFirst, boolean includeSecond) {
        long l2;
        int i2 = first.size() - 1;
        int j2 = second.size() - 1;
        if (first instanceof VoxelShapeCubePoint && second instanceof VoxelShapeCubePoint && (long)size * (l2 = VoxelShapes.a(i2, j2)) <= 256L) {
            return new VoxelShapeCubeMerger(i2, j2);
        }
        if (i2 == j2 && Objects.equals(first, second)) {
            if (first instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)first;
            }
            if (second instanceof VoxelShapeMergerIdentical) {
                return (VoxelShapeMerger)second;
            }
            return new VoxelShapeMergerIdentical(first);
        }
        if (first.getDouble(i2) < second.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(first, second, false);
        }
        if (second.getDouble(j2) < first.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(second, first, true);
        }
        return new VoxelShapeMergerList(first, second, includeFirst, includeSecond);
    }

    public static interface a {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

