/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import com.google.common.base.Preconditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.bukkit.Axis;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;

public class CraftEffect {
    public static <T> int getDataValue(Effect effect, T data) {
        return switch (effect) {
            case Effect.PARTICLES_SCULK_CHARGE, Effect.TRIAL_SPAWNER_DETECT_PLAYER, Effect.BEE_GROWTH, Effect.TURTLE_EGG_PLACEMENT, Effect.SMASH_ATTACK, Effect.TRIAL_SPAWNER_DETECT_PLAYER_OMINOUS, Effect.VILLAGER_PLANT_GROW -> (Integer)data;
            case Effect.POTION_BREAK, Effect.INSTANT_POTION_BREAK -> ((Color)data).asRGB();
            case Effect.RECORD_PLAY -> {
                Preconditions.checkArgument((data == Material.AIR || ((Material)data).isRecord() ? 1 : 0) != 0, (String)"Invalid record type for Material %s!", data);
                yield Item.a(CraftItemType.bukkitToMinecraft((Material)data));
            }
            case Effect.SHOOT_WHITE_SMOKE -> {
                BlockFace face = (BlockFace)data;
                Preconditions.checkArgument((boolean)face.isCartesian(), (Object)(String.valueOf(face) + " isn't cartesian"));
                yield CraftBlock.blockFaceToNotch(face).d();
            }
            case Effect.SMOKE -> {
                switch ((BlockFace)data) {
                    case DOWN: 
                    case NORTH_EAST: 
                    case NORTH_WEST: 
                    case SOUTH_EAST: 
                    case SOUTH_WEST: 
                    case SELF: {
                        yield 0;
                    }
                    case UP: {
                        yield 1;
                    }
                    case NORTH: {
                        yield 2;
                    }
                    case SOUTH: {
                        yield 3;
                    }
                    case WEST: {
                        yield 4;
                    }
                    case EAST: {
                        yield 5;
                    }
                }
                throw new IllegalArgumentException("Bad smoke direction!");
            }
            case Effect.STEP_SOUND -> {
                if (data instanceof Material) {
                    Preconditions.checkArgument((boolean)((Material)data).isBlock(), (String)"Material %s is not a block!", data);
                    yield Block.i(CraftBlockType.bukkitToMinecraft((Material)data).o());
                }
            }
            case Effect.PARTICLES_AND_SOUND_BRUSH_BLOCK_COMPLETE -> Block.i(((CraftBlockData)data).getState());
            case Effect.COMPOSTER_FILL_ATTEMPT, Effect.TRIAL_SPAWNER_SPAWN, Effect.TRIAL_SPAWNER_SPAWN_MOB_AT, Effect.VAULT_ACTIVATE, Effect.VAULT_DEACTIVATE, Effect.TRIAL_SPAWNER_BECOME_OMINOUS, Effect.TRIAL_SPAWNER_SPAWN_ITEM -> (Boolean)data != false ? 1 : 0;
            case Effect.BONE_MEAL_USE -> (Integer)data;
            case Effect.ELECTRIC_SPARK -> {
                if (data == null) {
                    yield -1;
                }
                switch ((Axis)data) {
                    case X: {
                        yield 0;
                    }
                    case Y: {
                        yield 1;
                    }
                    case Z: {
                        yield 2;
                    }
                }
                throw new IllegalArgumentException("Bad electric spark axis!");
            }
            default -> 0;
        };
    }
}

