/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1;

import java.util.Locale;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;

public class CraftEquipmentSlot {
    private static final EnumItemSlot[] slots = new EnumItemSlot[EquipmentSlot.values().length];
    private static final EquipmentSlot[] enums = new EquipmentSlot[EnumItemSlot.values().length];

    private static void set(EquipmentSlot type, EnumItemSlot value) {
        CraftEquipmentSlot.slots[type.ordinal()] = value;
        CraftEquipmentSlot.enums[value.ordinal()] = type;
    }

    public static EquipmentSlot getSlot(EnumItemSlot nms) {
        return enums[nms.ordinal()];
    }

    public static EquipmentSlotGroup getSlot(net.minecraft.world.entity.EquipmentSlotGroup nms) {
        return EquipmentSlotGroup.getByName((String)nms.c());
    }

    public static EnumItemSlot getNMS(EquipmentSlot slot) {
        return slots[slot.ordinal()];
    }

    public static net.minecraft.world.entity.EquipmentSlotGroup getNMSGroup(EquipmentSlotGroup slot) {
        return net.minecraft.world.entity.EquipmentSlotGroup.valueOf(slot.toString().toUpperCase(Locale.ROOT));
    }

    public static EquipmentSlot getHand(EnumHand enumhand) {
        return enumhand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
    }

    public static EnumHand getHand(EquipmentSlot hand) {
        if (hand == EquipmentSlot.HAND) {
            return EnumHand.a;
        }
        if (hand == EquipmentSlot.OFF_HAND) {
            return EnumHand.b;
        }
        throw new IllegalArgumentException("EquipmentSlot." + String.valueOf(hand) + " is not a hand");
    }

    static {
        CraftEquipmentSlot.set(EquipmentSlot.HAND, EnumItemSlot.a);
        CraftEquipmentSlot.set(EquipmentSlot.OFF_HAND, EnumItemSlot.b);
        CraftEquipmentSlot.set(EquipmentSlot.FEET, EnumItemSlot.c);
        CraftEquipmentSlot.set(EquipmentSlot.LEGS, EnumItemSlot.d);
        CraftEquipmentSlot.set(EquipmentSlot.CHEST, EnumItemSlot.e);
        CraftEquipmentSlot.set(EquipmentSlot.HEAD, EnumItemSlot.f);
        CraftEquipmentSlot.set(EquipmentSlot.BODY, EnumItemSlot.g);
    }
}

