/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Items;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.EnderSignal;
import org.bukkit.inventory.ItemStack;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, EntityEnderSignal entity) {
        super(server, entity);
    }

    @Override
    public EntityEnderSignal getHandle() {
        return (EntityEnderSignal)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    public Location getTargetLocation() {
        return new Location(this.getWorld(), this.getHandle().c, this.getHandle().d, this.getHandle().e, this.getHandle().dE(), this.getHandle().dG());
    }

    public void setTargetLocation(Location location) {
        this.setTargetLocation(location, true);
    }

    public void setTargetLocation(Location location, boolean update) {
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.getHandle().signalTo(CraftLocation.toBlockPosition(location), update);
    }

    public boolean getDropItem() {
        return this.getHandle().g;
    }

    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().g = shouldDropItem;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().p());
    }

    public void setItem(ItemStack item) {
        this.getHandle().a(item != null ? CraftItemStack.asNMSCopy(item) : Items.ss.w());
    }

    public int getDespawnTimer() {
        return this.getHandle().f;
    }

    public void setDespawnTimer(int time) {
        this.getHandle().f = time;
    }
}

