/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.world.entity.item.EntityItem;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftItem
extends CraftEntity
implements Item {
    private static final int NO_AGE_TIME = Short.MIN_VALUE;
    private static final int NO_PICKUP_TIME = Short.MAX_VALUE;

    public CraftItem(CraftServer server, EntityItem entity) {
        super(server, entity);
    }

    @Override
    public EntityItem getHandle() {
        return (EntityItem)this.entity;
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().p());
    }

    public void setItemStack(ItemStack stack) {
        this.getHandle().a(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.getHandle().j;
    }

    public void setPickupDelay(int delay) {
        this.getHandle().j = Math.min(delay, Short.MAX_VALUE);
    }

    public void setUnlimitedLifetime(boolean unlimited) {
        this.getHandle().i = unlimited ? Short.MIN_VALUE : this.getTicksLived();
    }

    public boolean isUnlimitedLifetime() {
        return this.getHandle().i == Short.MIN_VALUE;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        if (!this.isUnlimitedLifetime()) {
            this.getHandle().i = value;
        }
    }

    public boolean canMobPickup() {
        return this.getHandle().canMobPickup;
    }

    public void setCanMobPickup(boolean canMobPickup) {
        this.getHandle().canMobPickup = canMobPickup;
    }

    public boolean canPlayerPickup() {
        return this.getHandle().j != Short.MAX_VALUE;
    }

    public void setCanPlayerPickup(boolean canPlayerPickup) {
        this.getHandle().j = canPlayerPickup ? 0 : Short.MAX_VALUE;
    }

    public boolean willAge() {
        return this.getHandle().i != Short.MIN_VALUE;
    }

    public void setWillAge(boolean willAge) {
        this.getHandle().i = willAge ? 0 : Short.MIN_VALUE;
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.getHandle().frictionState = state;
    }

    public int getHealth() {
        return this.getHandle().k;
    }

    public void setHealth(int health) {
        if (health <= 0) {
            this.getHandle().p().a(this.getHandle());
            this.getHandle().discard(EntityRemoveEvent.Cause.PLUGIN);
        } else {
            this.getHandle().k = health;
        }
    }

    public void setOwner(UUID uuid) {
        this.getHandle().b(uuid);
    }

    public UUID getOwner() {
        return this.getHandle().n;
    }

    public void setThrower(UUID uuid) {
        this.getHandle().l = uuid;
    }

    public UUID getThrower() {
        return this.getHandle().l;
    }

    @Override
    public String toString() {
        return "CraftItem";
    }
}

