/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.bukkit.Art;
import org.bukkit.Registry;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.CraftArt;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHanging;
import org.bukkit.entity.Painting;

public class CraftPainting
extends CraftHanging
implements Painting {
    public CraftPainting(CraftServer server, EntityPainting entity) {
        super(server, entity);
    }

    public Art getArt() {
        return (Art)CraftRegistry.unwrapAndConvertHolder(Registry.ART, this.getHandle().v()).orElseThrow(() -> new IllegalStateException("Inlined/custom painting variants are not supported yet in the API!"));
    }

    public boolean setArt(Art art) {
        return this.setArt(art, false);
    }

    public boolean setArt(Art art, boolean force) {
        EntityPainting painting = this.getHandle();
        Holder<PaintingVariant> oldArt = painting.v();
        painting.b(CraftArt.bukkitToMinecraftHolder(art));
        painting.a(painting.cH());
        if (!(force || this.getHandle().generation || painting.s())) {
            painting.b(oldArt);
            painting.a(painting.cH());
            return false;
        }
        return true;
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        if (super.setFacingDirection(face, force)) {
            this.update();
            return true;
        }
        return false;
    }

    @Override
    public EntityPainting getHandle() {
        return (EntityPainting)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPainting{art=" + String.valueOf(this.getArt()) + "}";
    }
}

