/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory.util;

import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.TileInventory;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.util.CraftMenuBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.BeaconView;
import org.bukkit.inventory.view.BrewingStandView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.FurnaceView;
import org.bukkit.inventory.view.LecternView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.StonecutterView;

public final class CraftMenus {
    private static final CraftMenuBuilder STANDARD = (player, menuType) -> menuType.a(player.nextContainerCounter(), player.fY());

    public static <V extends InventoryView> MenuTypeData<V> getMenuTypeData(CraftMenuType<?> menuType) {
        if (menuType == MenuType.GENERIC_3X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.tileEntity(TileEntityDispenser::new, Blocks.aU)));
        }
        if (menuType == MenuType.CRAFTER_3X3) {
            return CraftMenus.asType(new MenuTypeData<CrafterView>(CrafterView.class, CraftMenuBuilder.tileEntity(CrafterBlockEntity::new, Blocks.tq)));
        }
        if (menuType == MenuType.ANVIL) {
            return CraftMenus.asType(new MenuTypeData<AnvilView>(AnvilView.class, CraftMenuBuilder.worldAccess(ContainerAnvil::new)));
        }
        if (menuType == MenuType.BEACON) {
            return CraftMenus.asType(new MenuTypeData<BeaconView>(BeaconView.class, CraftMenuBuilder.tileEntity(TileEntityBeacon::new, Blocks.fO)));
        }
        if (menuType == MenuType.BLAST_FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(TileEntityBlastFurnace::new, Blocks.nW)));
        }
        if (menuType == MenuType.BREWING_STAND) {
            return CraftMenus.asType(new MenuTypeData<BrewingStandView>(BrewingStandView.class, CraftMenuBuilder.tileEntity(TileEntityBrewingStand::new, Blocks.fs)));
        }
        if (menuType == MenuType.CRAFTING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(ContainerWorkbench::new)));
        }
        if (menuType == MenuType.ENCHANTMENT) {
            return CraftMenus.asType(new MenuTypeData<EnchantmentView>(EnchantmentView.class, (player, type) -> new TileInventory((syncId, inventory, human) -> CraftMenuBuilder.worldAccess(ContainerEnchantTable::new).build(player, type), IChatBaseComponent.i()).createMenu(player.nextContainerCounter(), player.fY(), player)));
        }
        if (menuType == MenuType.FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(TileEntityFurnaceFurnace::new, Blocks.cD)));
        }
        if (menuType == MenuType.GRINDSTONE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(ContainerGrindstone::new)));
        }
        if (menuType == MenuType.HOPPER) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.tileEntity(TileEntityHopper::new, Blocks.hc)));
        }
        if (menuType == MenuType.LECTERN) {
            return CraftMenus.asType(new MenuTypeData<LecternView>(LecternView.class, CraftMenuBuilder.tileEntity(TileEntityLectern::new, Blocks.oa)));
        }
        if (menuType == MenuType.LOOM) {
            return CraftMenus.asType(new MenuTypeData<LoomView>(LoomView.class, STANDARD));
        }
        if (menuType == MenuType.MERCHANT) {
            return CraftMenus.asType(new MenuTypeData<MerchantView>(MerchantView.class, STANDARD));
        }
        if (menuType == MenuType.SMITHING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(ContainerSmithing::new)));
        }
        if (menuType == MenuType.SMOKER) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView>(FurnaceView.class, CraftMenuBuilder.tileEntity(TileEntitySmoker::new, Blocks.nV)));
        }
        if (menuType == MenuType.CARTOGRAPHY_TABLE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, CraftMenuBuilder.worldAccess(ContainerCartography::new)));
        }
        if (menuType == MenuType.STONECUTTER) {
            return CraftMenus.asType(new MenuTypeData<StonecutterView>(StonecutterView.class, CraftMenuBuilder.worldAccess(ContainerStonecutter::new)));
        }
        return CraftMenus.asType(new MenuTypeData<InventoryView>(InventoryView.class, STANDARD));
    }

    private static <V extends InventoryView> MenuTypeData<V> asType(MenuTypeData<?> data) {
        return data;
    }

    public record MenuTypeData<V extends InventoryView>(Class<V> viewClass, CraftMenuBuilder menuBuilder) {
    }
}

