/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.spawner;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.spawner.Spawner;

public interface PaperSharedSpawnerLogic
extends Spawner {
    public MobSpawnerAbstract getSpawner();

    public World getInternalWorld();

    public BlockPosition getInternalPosition();

    default public boolean isActivated() {
        return this.getSpawner().c(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void resetTimer() {
        this.getSpawner().d(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void setNextSpawnData(MobSpawnerData spawnData) {
        this.getSpawner().a(this.getInternalWorld(), this.getInternalPosition(), spawnData);
    }

    default public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        NBTTagCompound entity = new NBTTagCompound();
        entity.a("id", BuiltInRegistries.f.b(EntityTypes.ag).toString());
        entity.a("Item", item.a(this.getInternalWorld().H_()));
        this.setNextSpawnData(new MobSpawnerData(entity, Optional.empty(), Optional.ofNullable(this.getSpawner().f).flatMap(MobSpawnerData::f)));
    }
}

