/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter.runtime;

import io.papermc.reflectionrewriter.runtime.DefaultRulesReflectionProxy;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;

public abstract class AbstractDefaultRulesReflectionProxy
implements DefaultRulesReflectionProxy {
    protected AbstractDefaultRulesReflectionProxy() {
    }

    protected abstract String mapClassName(String var1);

    protected abstract String mapDeclaredMethodName(Class<?> var1, String var2, Class<?> ... var3);

    protected abstract String mapMethodName(Class<?> var1, String var2, Class<?> ... var3);

    protected abstract String mapDeclaredFieldName(Class<?> var1, String var2);

    protected abstract String mapFieldName(Class<?> var1, String var2);

    protected final String mapClassOrArrayName(String name) {
        Objects.requireNonNull(name, "name");
        if (name.isBlank()) {
            return name;
        }
        if (name.charAt(0) == '[') {
            int last = name.lastIndexOf(91);
            try {
                if (name.charAt(last + 1) == 'L') {
                    String cls = name.substring(last + 2, name.length() - 1);
                    return name.substring(0, last + 2) + this.mapClassName(cls) + ";";
                }
            }
            catch (IndexOutOfBoundsException ex) {
                return name;
            }
            return name;
        }
        return this.mapClassName(name);
    }

    private static ClassLoader callerClassLoader() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> stream.skip(3L).findFirst().map(frame -> frame.getDeclaringClass().getClassLoader()).orElseThrow());
    }

    @Override
    public Class<?> forName(String name) throws ClassNotFoundException {
        return Class.forName(this.mapClassOrArrayName(name), true, AbstractDefaultRulesReflectionProxy.callerClassLoader());
    }

    @Override
    public Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(this.mapClassOrArrayName(name), initialize, loader);
    }

    @Override
    public Class<?> forName(Module module, String name) {
        return Class.forName(module, this.mapClassOrArrayName(name));
    }

    @Override
    public Field getField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
        return clazz.getField(this.mapFieldName(clazz, name));
    }

    @Override
    public Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException, SecurityException {
        return clazz.getDeclaredField(this.mapDeclaredFieldName(clazz, name));
    }

    @Override
    public Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return clazz.getDeclaredMethod(this.mapDeclaredMethodName(clazz, name, parameterTypes), parameterTypes);
    }

    @Override
    public Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return clazz.getMethod(this.mapMethodName(clazz, name, parameterTypes), parameterTypes);
    }

    @Override
    public MethodHandle findStatic(MethodHandles.Lookup lookup, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        return lookup.findStatic(refc, this.mapMethodName(refc, name, type.parameterArray()), type);
    }

    @Override
    public MethodHandle findVirtual(MethodHandles.Lookup lookup, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        return lookup.findVirtual(refc, this.mapMethodName(refc, name, type.parameterArray()), type);
    }

    @Override
    public Class<?> findClass(MethodHandles.Lookup lookup, String targetName) throws ClassNotFoundException, IllegalAccessException {
        return lookup.findClass(this.mapClassOrArrayName(targetName));
    }

    @Override
    public MethodHandle findSpecial(MethodHandles.Lookup lookup, Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
        return lookup.findSpecial(refc, this.mapMethodName(refc, name, type.parameterArray()), type, specialCaller);
    }

    @Override
    public MethodHandle findGetter(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findGetter(refc, this.mapFieldName(refc, name), type);
    }

    @Override
    public MethodHandle findSetter(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findSetter(refc, this.mapFieldName(refc, name), type);
    }

    @Override
    public MethodHandle findStaticGetter(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findStaticGetter(refc, this.mapFieldName(refc, name), type);
    }

    @Override
    public MethodHandle findStaticSetter(MethodHandles.Lookup lookup, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findStaticSetter(refc, this.mapFieldName(refc, name), type);
    }

    @Override
    public MethodHandle bind(MethodHandles.Lookup lookup, Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        return lookup.bind(receiver, this.mapMethodName(receiver.getClass(), name, type.parameterArray()), type);
    }

    @Override
    public VarHandle findVarHandle(MethodHandles.Lookup lookup, Class<?> recv, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findVarHandle(recv, this.mapFieldName(recv, name), type);
    }

    @Override
    public VarHandle findStaticVarHandle(MethodHandles.Lookup lookup, Class<?> decl, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
        return lookup.findStaticVarHandle(decl, this.mapFieldName(decl, name), type);
    }

    @Override
    public CallSite metafactory(MethodHandles.Lookup caller, String interfaceMethodName, MethodType factoryType, MethodType interfaceMethodType, MethodHandle implementation, MethodType dynamicMethodType) throws LambdaConversionException {
        return LambdaMetafactory.metafactory(caller, this.mapMethodName((Class<?>)factoryType.returnType(), interfaceMethodName, dynamicMethodType.parameterArray()), factoryType, interfaceMethodType, implementation, dynamicMethodType);
    }

    @Override
    public CallSite altMetafactory(MethodHandles.Lookup caller, String interfaceMethodName, MethodType factoryType, Object ... args) throws LambdaConversionException {
        Object object;
        if (args.length < 3 || !((object = args[2]) instanceof MethodType)) {
            throw new IllegalArgumentException("illegal or missing argument");
        }
        MethodType dynamicMethodType = (MethodType)object;
        return LambdaMetafactory.altMetafactory(caller, this.mapMethodName((Class<?>)factoryType.returnType(), interfaceMethodName, dynamicMethodType.parameterArray()), factoryType, args);
    }

    @Override
    public Object getStaticFinal(MethodHandles.Lookup lookup, String name, Class<?> type, Class<?> declaringClass) {
        return ConstantBootstraps.getStaticFinal(lookup, this.mapFieldName(declaringClass, name), type, declaringClass);
    }

    @Override
    public Object getStaticFinal(MethodHandles.Lookup lookup, String name, Class<?> type) {
        return ConstantBootstraps.getStaticFinal(lookup, this.mapFieldName(type, name), type);
    }

    @Override
    public VarHandle fieldVarHandle(MethodHandles.Lookup lookup, String name, Class<VarHandle> type, Class<?> declaringClass, Class<?> fieldType) {
        return ConstantBootstraps.fieldVarHandle(lookup, this.mapFieldName(declaringClass, name), type, declaringClass, fieldType);
    }

    @Override
    public VarHandle staticFieldVarHandle(MethodHandles.Lookup lookup, String name, Class<VarHandle> type, Class<?> declaringClass, Class<?> fieldType) {
        return ConstantBootstraps.staticFieldVarHandle(lookup, this.mapFieldName(declaringClass, name), type, declaringClass, fieldType);
    }

    @Override
    public MethodType fromMethodDescriptorString(String descriptor, ClassLoader loader) throws IllegalArgumentException, TypeNotPresentException {
        if (descriptor.indexOf(76) == -1) {
            return MethodType.fromMethodDescriptorString(descriptor, loader);
        }
        StringBuilder desc = new StringBuilder(descriptor.length());
        int i = 0;
        int length = descriptor.length();
        while (i < length) {
            char c = descriptor.charAt(i);
            ++i;
            desc.append(c);
            if (c != 'L') continue;
            int endIndex = descriptor.indexOf(59, i);
            if (endIndex == -1) {
                throw new IllegalArgumentException("'" + descriptor + "' is not a valid method descriptor.");
            }
            String unmappedSlash = descriptor.substring(i, endIndex);
            String unmappedDot = unmappedSlash.replace('/', '.');
            String mappedDot = this.mapClassName(unmappedDot);
            String result = mappedDot.equals(unmappedDot) ? unmappedSlash : mappedDot.replace('.', '/');
            i = endIndex;
            desc.append(result);
        }
        return MethodType.fromMethodDescriptorString(desc.toString(), loader);
    }
}

