/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import me.uwpctf.GameProperties;
import me.uwpctf.UwpCTF;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Helpers {
    public static int[] get3AxisDistance(Location loc1, Location loc2) {
        int x = Math.abs(loc1.getBlockX() - loc2.getBlockX());
        int y = Math.abs(loc1.getBlockY() - loc2.getBlockY());
        int z = Math.abs(loc1.getBlockZ() - loc2.getBlockZ());
        return new int[]{x, y, z};
    }

    public static void playVictory(final Player p) {
        new BukkitRunnable(){
            int count = 0;

            public void run() {
                if (this.count < 3) {
                    p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, (float)this.count);
                    ++this.count;
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)JavaPlugin.getPlugin(UwpCTF.class), 0L, 5L);
    }

    public static void playAlarm(final Player p) {
        new BukkitRunnable(){
            int count = 3;

            public void run() {
                if (this.count > 0) {
                    p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, 1.0f, 2.0f);
                    --this.count;
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)JavaPlugin.getPlugin(UwpCTF.class), 0L, 5L);
    }

    public static boolean withinDistance(Location loc1, Location loc2, int distance) {
        if (loc1 == null || loc2 == null) {
            return false;
        }
        int[] axis = Helpers.get3AxisDistance(loc1, loc2);
        return axis[0] <= distance && axis[1] <= distance && axis[2] <= distance;
    }

    public static void cancelLootDrop(PlayerDeathEvent e) {
        e.setKeepInventory(true);
        e.setKeepLevel(true);
        e.getDrops().clear();
        e.setDroppedExp(0);
    }

    public static void debug() {
        new BukkitRunnable(){

            public void run() {
                System.out.println("");
                System.out.println("Blue Flag Location Base: " + GameProperties.blueFlagLocationBase());
                System.out.println("Red Flag Location Base: " + GameProperties.redFlagLocationBase());
                System.out.println("Blue Flag Current Location: " + GameProperties.blueFlagCurrentLocation());
                System.out.println("Red Flag Current Location: " + GameProperties.redFlagCurrentLocation());
            }
        }.runTaskTimer((Plugin)JavaPlugin.getPlugin(UwpCTF.class), 0L, 30L);
    }
}

