/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import me.uwpctf.FlagLogic;
import me.uwpctf.GameManager;
import me.uwpctf.GameProperties;
import me.uwpctf.Players;
import me.uwpctf.Teams;
import me.uwpctf.UwpCTF;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Runnable {
    private static int gameTicksElapsed = 1;

    public static void runEvery2Ticks() {
        new BukkitRunnable(){

            public void run() {
                Teams.updateScoreboard();
                for (Player p : Players.getPlayers()) {
                    Particle.DustOptions dustOptions;
                    if (GameProperties.blueFlagCarrier() != null && GameProperties.blueFlagCarrier().equals((Object)p)) {
                        dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)255), 1.0f);
                        p.getWorld().spawnParticle(Particle.DUST, p.getLocation(), 45, 1.0, 0.0, 1.0, (Object)dustOptions);
                    }
                    if (GameProperties.redFlagCarrier() == null || !GameProperties.redFlagCarrier().equals((Object)p)) continue;
                    dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)0), 1.0f);
                    p.getWorld().spawnParticle(Particle.DUST, p.getLocation(), 45, 1.0, 0.0, 1.0, (Object)dustOptions);
                }
                if (!GameProperties.hideScoreboardAndParticles()) {
                    Location particleLocation;
                    Particle.DustOptions dustOptions;
                    if (GameProperties.blueFlagLocationBase() != null && !GameProperties.blueFlagLocationBase().equals((Object)GameProperties.blueFlagCurrentLocation())) {
                        dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)0), 1.0f);
                        particleLocation = GameProperties.blueFlagLocationBase().clone().add(0.0, 1.0, 0.0);
                        particleLocation.getWorld().spawnParticle(Particle.DUST, particleLocation, 25, 0.2, 0.4, 0.2, (Object)dustOptions);
                    }
                    if (GameProperties.redFlagLocationBase() != null && !GameProperties.redFlagLocationBase().equals((Object)GameProperties.redFlagCurrentLocation())) {
                        dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)0), 1.0f);
                        particleLocation = GameProperties.redFlagLocationBase().clone().add(0.0, 1.0, 0.0);
                        particleLocation.getWorld().spawnParticle(Particle.DUST, particleLocation, 25, 0.2, 0.4, 0.2, (Object)dustOptions);
                    }
                }
                if (GameProperties.blueFlagOnGround().booleanValue() && !GameProperties.blueFlagLocationBase().equals((Object)GameProperties.blueFlagCurrentLocation())) {
                    if (GameProperties.blueFlagCurrentLocation() == null) {
                        return;
                    }
                    for (int i = 5; i < 100; ++i) {
                        GameProperties.blueFlagCurrentLocation().getWorld().spawnParticle(Particle.LARGE_SMOKE, GameProperties.blueFlagCurrentLocation().clone().add(0.5, (double)i, 0.5), 2, 0.0, 0.3, 0.0, 0.0);
                    }
                }
                if (GameProperties.redFlagOnGround().booleanValue() && !GameProperties.redFlagLocationBase().equals((Object)GameProperties.redFlagCurrentLocation())) {
                    if (GameProperties.redFlagCurrentLocation() == null) {
                        return;
                    }
                    for (int i = 5; i < 100; ++i) {
                        GameProperties.redFlagCurrentLocation().getWorld().spawnParticle(Particle.LARGE_SMOKE, GameProperties.redFlagCurrentLocation().clone().add(0.5, (double)i, 0.5), 2, 0.0, 0.3, 0.0, 0.0);
                    }
                }
                if (GameProperties.blueFlagOnGround().booleanValue()) {
                    FlagLogic.spawnBlueFlag(GameProperties.blueFlagCurrentLocation());
                }
                if (GameProperties.redFlagOnGround().booleanValue()) {
                    FlagLogic.spawnRedFlag(GameProperties.redFlagCurrentLocation());
                }
            }
        }.runTaskTimer((Plugin)JavaPlugin.getPlugin(UwpCTF.class), 0L, 2L);
    }

    public static void gameTimer(int delay, int durationMins) {
        new BukkitRunnable(){

            public void run() {
                if (!GameProperties.isGamePaused()) {
                    FlagLogic.calculateCaptures();
                    gameTicksElapsed++;
                }
                if (!GameProperties.mainGameRunning()) {
                    this.cancel();
                }
                if (GameProperties.minutesUntilGameEnd() == 0) {
                    GameManager.endGame();
                    this.cancel();
                }
                if (Players.getPlayers().size() < 2) {
                    GameManager.endGame();
                    this.cancel();
                }
                if (Teams.blue.getSize() < 1 && Teams.red.getSize() > 0) {
                    GameManager.endGame();
                    this.cancel();
                }
                if (Teams.red.getSize() < 1 && Teams.blue.getSize() > 0) {
                    GameManager.endGame();
                    this.cancel();
                }
                if (gameTicksElapsed % 1200 == 0) {
                    GameProperties.setMinutesUntilGameEnd(GameProperties.minutesUntilGameEnd() - 1);
                }
            }
        }.runTaskTimer((Plugin)JavaPlugin.getPlugin(UwpCTF.class), (long)delay, 1L);
    }
}

