/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import me.uwpctf.GameProperties;
import me.uwpctf.Helpers;
import me.uwpctf.Players;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class Teams
implements Listener {
    public static Team red;
    public static Team blue;
    static Scoreboard board;
    static Objective obj;
    static Team BlueInfo;
    static Team RedInfo;
    static Team GameInfo;

    public static void initializeTeams() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        board = manager.getNewScoreboard();
        obj = board.registerNewObjective("MainScoreboard", "dummy", ChatColor.BOLD + "------ UWP CTF ------");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        GameInfo = board.registerNewTeam("GameInfo");
        GameInfo.addEntry(ChatColor.AQUA.toString());
        GameInfo.setPrefix(ChatColor.GREEN + "");
        GameInfo.setSuffix("");
        obj.getScore(ChatColor.AQUA.toString()).setScore(2);
        BlueInfo = board.registerNewTeam("BlueInfo");
        BlueInfo.addEntry(ChatColor.WHITE.toString());
        BlueInfo.setPrefix(ChatColor.BLUE + "Blue Score: ");
        BlueInfo.setSuffix("");
        obj.getScore(ChatColor.WHITE.toString()).setScore(1);
        RedInfo = board.registerNewTeam("RedInfo");
        RedInfo.addEntry(ChatColor.BLACK.toString());
        RedInfo.setPrefix(ChatColor.RED + "Red Score: ");
        RedInfo.setSuffix("");
        obj.getScore(ChatColor.BLACK.toString()).setScore(0);
        blue = board.registerNewTeam("Blue");
        blue.setPrefix(ChatColor.BLUE + "[BLUE] " + ChatColor.WHITE);
        blue.setAllowFriendlyFire(false);
        blue.setCanSeeFriendlyInvisibles(true);
        red = board.registerNewTeam("Red");
        red.setPrefix(ChatColor.RED + "[RED] " + ChatColor.WHITE);
        red.setAllowFriendlyFire(false);
        red.setCanSeeFriendlyInvisibles(true);
    }

    public static void broadcastMessage(String message, String team) {
        for (Player p : Players.getPlayers()) {
            if (team.equalsIgnoreCase("Red")) {
                if (!red.hasEntry(p.getName())) continue;
                p.sendTitle(message, "", 10, 50, 20);
                continue;
            }
            if (!team.equalsIgnoreCase("Blue") || !blue.hasEntry(p.getName())) continue;
            p.sendTitle(message, "", 10, 50, 20);
        }
    }

    public static void playVictory(String team) {
        for (Player p : Players.getPlayers()) {
            if (!Teams.getTeam(p).equalsIgnoreCase(team)) continue;
            Helpers.playVictory(p);
        }
    }

    public static void playAlarm(String team) {
        for (Player p : Players.getPlayers()) {
            if (!Teams.getTeam(p).equalsIgnoreCase(team)) continue;
            Helpers.playAlarm(p);
        }
    }

    public static void updateScoreboard() {
        for (Player p : Players.getPlayers()) {
            if (GameProperties.hideScoreboardAndParticles()) {
                p.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                continue;
            }
            RedInfo.setSuffix(ChatColor.GOLD + Integer.toString(GameProperties.redTeamScore()));
            BlueInfo.setSuffix(ChatColor.GOLD + Integer.toString(GameProperties.blueTeamScore()));
            if (GameProperties.mainGameRunning()) {
                if (GameProperties.isGamePaused()) {
                    GameInfo.setSuffix(ChatColor.GREEN + "Game Paused - " + ChatColor.GOLD + GameProperties.minutesUntilGameEnd() + " minutes left");
                } else {
                    GameInfo.setSuffix(ChatColor.GREEN + "Game Ending in " + ChatColor.GOLD + GameProperties.minutesUntilGameEnd() + " minutes");
                }
            } else {
                GameInfo.setSuffix(ChatColor.GREEN + "No Game Running");
            }
            p.setScoreboard(board);
        }
    }

    public static void hideAllScoreBoard() {
        for (Player p : Players.getPlayers()) {
            p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
    }

    public static void hideScoreBoard(Player p) {
        p.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public static void addPlayerBlueTeam(Player p) {
        blue.addEntry(p.getName());
        if (red.hasEntry(p.getName())) {
            red.removeEntry(p.getName());
        }
    }

    public static void addPlayerRedTeam(Player p) {
        red.addEntry(p.getName());
        if (blue.hasEntry(p.getName())) {
            blue.removeEntry(p.getName());
        }
    }

    public static void RemovePlayerFromTeam(Player p) {
        if (red.hasEntry(p.getName())) {
            red.removeEntry(p.getName());
        } else if (blue.hasEntry(p.getName())) {
            blue.removeEntry(p.getName());
        }
    }

    public static String getTeam(Player p) {
        if (red.hasEntry(p.getName())) {
            return "Red";
        }
        if (blue.hasEntry(p.getName())) {
            return "Blue";
        }
        return "None";
    }
}

