/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import java.util.ArrayList;
import me.uwpctf.GameManager;
import me.uwpctf.GameProperties;
import me.uwpctf.Players;
import me.uwpctf.Teams;
import me.uwpctf.UwpCTF;
import me.uwpctf.YamlHandler;
import me.uwpctf.dbHandler;
import me.uwpctf.values;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class preGameQueue
implements Listener,
CommandExecutor {
    private BukkitRunnable gameTimer;
    public static boolean notifiedOnceNotEnough;
    public static boolean countdownStarted;
    public static boolean notifiedOnceOddNumber;
    values val;
    public static boolean isGameRunning;
    static int countdown;
    static boolean queueTimerRunning;

    public static void ResetGameRunning() {
        isGameRunning = false;
    }

    public preGameQueue() {
        notifiedOnceNotEnough = false;
        notifiedOnceOddNumber = false;
        YamlHandler yamlHandler = new YamlHandler();
        this.val = yamlHandler.readYaml();
    }

    public void startGame(Player p) {
        if (isGameRunning) {
            return;
        }
        isGameRunning = true;
        World gameWorld = Bukkit.getWorld((String)this.val.getGameWorld());
        dbHandler dbHandler2 = new dbHandler();
        double[] redCoordinates = dbHandler2.get_random_red();
        double[] blueCoordinates = dbHandler2.get_random_blue();
        GameProperties.setRedFlagLocationBase(new Location(gameWorld, redCoordinates[0], redCoordinates[1], redCoordinates[2]));
        GameProperties.setBlueFlagLocationBase(new Location(gameWorld, blueCoordinates[0], blueCoordinates[1], blueCoordinates[2]));
        int index = 0;
        for (Player player : Players.getPlayers()) {
            player.getInventory().clear();
            if (player != null) {
                if (index % 2 == 0) {
                    Teams.addPlayerRedTeam(player);
                    player.sendMessage(ChatColor.RED + "You are on the Red Team");
                } else {
                    Teams.addPlayerBlueTeam(player);
                    player.sendMessage(ChatColor.BLUE + "You are on the Blue Team");
                }
                player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
                player.closeInventory();
                ++index;
            }
            assert (player != null);
            player.sendMessage(ChatColor.GREEN + "Game Started");
        }
        GameProperties.setGameDuration(20);
        p.closeInventory();
        GameProperties.setBlueTeamScore(0);
        GameProperties.setRedTeamScore(0);
        GameProperties.setHideScoreboardAndParticles(false);
        GameManager.startGame();
    }

    static void resetStartUpState() {
        countdown = 75;
        queueTimerRunning = false;
        notifiedOnceNotEnough = false;
        notifiedOnceOddNumber = false;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String s, String[] strings) {
        Player p = (Player)sender;
        if (isGameRunning) {
            p.sendMessage("There is a game currently running! Please try again later.");
            return true;
        }
        if (Players.getPlayers().contains(p)) {
            p.sendMessage("You are already in the queue");
            return true;
        }
        if (Players.getPlayers().size() == 10) {
            p.sendMessage("The game is full!");
            Players.getPlayers().remove(p);
            return true;
        }
        p.getActivePotionEffects().clear();
        World gameWorld = Bukkit.getWorld((String)this.val.getGameWorld());
        p.teleport(new Location(gameWorld, (double)this.val.getQueueLocX(), (double)this.val.getQueueLocY(), (double)this.val.getQueueLocZ()));
        Players.getPlayers().add(p);
        p.getInventory().clear();
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setTitle(ChatColor.GOLD + "How to play");
        meta.setAuthor(ChatColor.AQUA + "UWPMC");
        meta.addPage(new String[]{ChatColor.BOLD + "How to play UWP\u2011CTF:\n" + ChatColor.GRAY + "Each team has a flag in a random location on their ship. "});
        meta.addPage(new String[]{ChatColor.GRAY + "The goal is to find, steal, and successfully bring back the opponent's flag " + ChatColor.GRAY + "to your ship's netherite block located at the rear by the stairs."});
        meta.addPage(new String[]{ChatColor.GRAY + "Flags spawn on purple blocks throughout each team's ship and the locations "});
        meta.addPage(new String[]{ChatColor.GRAY + "are randomized at the start of the game, and whenever a flag from either team " + ChatColor.GRAY + "is captured successfully."});
        meta.addPage(new String[]{ChatColor.GRAY + "The team with the highest score by the end of the game wins (or tie if both scores are identical)."});
        meta.addPage(new String[]{ChatColor.BOLD + "Game notes:\n" + ChatColor.GRAY + "If a flag carrier dies on land (void returns flag to opponents base, same location it was found) they will drop the flag, which all teams will be notified of."});
        meta.addPage(new String[]{ChatColor.GRAY + "If the flag is picked up by the team it belongs to, it is automatically returned to their base. " + ChatColor.GRAY + "If the flag is picked up by the opposing team, they will now have it with the goal of returning to their block with it."});
        meta.addPage(new String[]{ChatColor.BOLD + "Possible Flag Locations:\n" + ChatColor.GRAY + "There are many places flags can appear randomly. Some well hidden and blocked off, some in easy reach. They may appear at the top of the blimp balloon of the ship,"});
        meta.addPage(new String[]{ChatColor.GRAY + "inside the blimp balloon, the rudder of the ship, inside the sleeping quarters, "});
        meta.addPage(new String[]{ChatColor.GRAY + "at the bow, or behind the coal on the first level. This list includes some but not " + ChatColor.GRAY + "every possible spot. Be sure to search really well!"});
        meta.addPage(new String[]{ChatColor.BOLD + "Credits:\n" + ChatColor.GRAY + "Developers: Evan Niederwerfer (Class of 2027) - fork of: upsurge76's ram CTF plugin,  Map: Haffy6 (UWP Student)"});
        book.setItemMeta((ItemMeta)meta);
        p.getInventory().addItem(new ItemStack[]{book});
        this.startPlayerCheckTask(p);
        return true;
    }

    private void startPlayerCheckTask(final Player p) {
        new BukkitRunnable(){

            public void run() {
                if (Players.getPlayers().size() < 2) {
                    if (!notifiedOnceNotEnough) {
                        for (Player player : Players.getPlayers()) {
                            player.sendMessage("Waiting for more players.. (2+ required)");
                        }
                        notifiedOnceNotEnough = true;
                        queueTimerRunning = false;
                        countdown = 75;
                        this.cancel();
                    }
                } else if (Players.getPlayers().size() % 2 != 0 && !notifiedOnceOddNumber) {
                    for (Player player : Players.getPlayers()) {
                        player.sendMessage("Canceled: Odd player count detected. 2, 4, 6, 8, or 10 players needed to start game. Waiting...");
                        countdown = 30;
                        notifiedOnceOddNumber = true;
                    }
                    queueTimerRunning = false;
                    this.cancel();
                }
                notifiedOnceNotEnough = false;
                notifiedOnceOddNumber = false;
                preGameQueue.this.startGameTimer(p);
                this.cancel();
            }
        }.runTaskTimer((Plugin)UwpCTF.getInstance(), 0L, 20L);
    }

    private void startGameTimer(final Player p) {
        if (queueTimerRunning) {
            return;
        }
        if (this.gameTimer != null) {
            this.gameTimer.cancel();
            this.gameTimer = null;
        }
        countdownStarted = true;
        notifiedOnceNotEnough = false;
        notifiedOnceOddNumber = false;
        queueTimerRunning = true;
        this.gameTimer = new BukkitRunnable(){

            public void run() {
                ArrayList<Player> onlineQueued = new ArrayList<Player>();
                for (Player q : new ArrayList<Player>(Players.getPlayers())) {
                    if (q == null || !q.isOnline()) {
                        Players.getPlayers().remove(q);
                        continue;
                    }
                    onlineQueued.add(q);
                }
                int playerCount = onlineQueued.size();
                if (playerCount < 2) {
                    queueTimerRunning = false;
                    countdown = 75;
                    isGameRunning = false;
                    this.cancel();
                    return;
                }
                if (playerCount % 2 != 0) {
                    queueTimerRunning = false;
                    countdown = 30;
                    isGameRunning = false;
                    this.cancel();
                    return;
                }
                if (countdown <= 0) {
                    if (!isGameRunning) {
                        preGameQueue.this.startGame(p);
                        isGameRunning = true;
                    }
                    this.cancel();
                    return;
                }
                if (countdown == 75 || countdown == 60 || countdown == 45 || countdown == 30 || countdown == 15 || countdown == 10 || countdown < 6) {
                    for (Player player : Players.getPlayers()) {
                        player.sendMessage("Game starting in " + countdown + " seconds...");
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                    }
                }
                if (countdown == 60) {
                    Bukkit.broadcastMessage((String)("Capture The Flag will be starting in 60 seconds with " + Players.getPlayers().size() + " players!"));
                }
                if (countdown == 30) {
                    Bukkit.broadcastMessage((String)("Capture The Flag will be starting in 30 seconds with " + Players.getPlayers().size() + " players!"));
                }
                --countdown;
            }
        };
        this.gameTimer.runTaskTimer((Plugin)UwpCTF.getInstance(), 0L, 20L);
        queueTimerRunning = true;
    }

    static {
        isGameRunning = false;
        countdown = 75;
        queueTimerRunning = false;
    }
}

