/*
 * Decompiled with CFR 0.152.
 */
package me.arcodeskel.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.github.cdimascio.dotenv.Dotenv;
import java.sql.Connection;
import java.sql.SQLException;

public class DatabaseConnection {
    private static final HikariDataSource dataSource;

    public static Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public static void close() {
        if (dataSource != null) {
            dataSource.close();
        }
    }

    static {
        Dotenv dotenv = Dotenv.load();
        String ip = dotenv.get("IP_AND_PORT");
        String db = dotenv.get("DB_NAME");
        String username = dotenv.get("USERNAME");
        String password = dotenv.get("PASSWORD");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + ip + "/" + db);
        config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(10);
        config.setConnectionTestQuery("SELECT 1");
        dataSource = new HikariDataSource(config);
    }
}

