/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.destination;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.destination.PortalDestination;

public class PortalDestinationInstance
extends DestinationInstance<PortalDestinationInstance, PortalDestination> {
    private final MVPortal portal;
    private final String direction;
    private final float yaw;

    protected PortalDestinationInstance(@NotNull PortalDestination destination, @NotNull MVPortal portal, @Nullable String direction, float yaw) {
        super((Destination)destination);
        this.portal = portal;
        this.direction = direction;
        this.yaw = yaw;
    }

    public String getDirection() {
        return this.direction;
    }

    @NotNull
    public Option<Location> getLocation(@NotNull Entity teleportee) {
        return Option.of((Object)this.portal.getSafePlayerSpawnLocation()).peek(l -> l.setYaw(this.yaw));
    }

    @NotNull
    public Option<Vector> getVelocity(@NotNull Entity teleportee) {
        return Option.none();
    }

    public boolean checkTeleportSafety() {
        return this.portal.useSafeTeleporter();
    }

    @NotNull
    public Option<String> getFinerPermissionSuffix() {
        return Option.of((Object)this.portal.getName());
    }

    @NotNull
    protected String serialise() {
        if (this.direction != null) {
            return this.portal.getName() + ":" + this.direction;
        }
        return this.portal.getName();
    }
}

